
<div class="bg-light d-flex align-items-center position-relative min-vh-100 py-6">
    <?php if (isset($page_title) && $page_title == 'Register'): ?>
    <!-- Register form -->
    <div class="container <?php if(settings()->site_info == 3){echo "d-hide";} ?>">
        <div class="row cards">
            <div class="col-md-8 my-4 py-5 m-auto shadow-light bg-white rounded" data-aos="fade-up"
                data-aos-duration="300">

                <?php if (settings()->enable_registration == 0): ?>
                    <div class="mb-6 text-center">
                        <img class="mb-4" width="30%" src="<?php echo base_url('assets/front/img/not-found.png') ?>">
                        <h3 class="text-muted"><?php echo trans('registration-system-is-disabled-') ?> </h3>
                        <a class="btn btn-secondary btn-sm mt-2" href="<?php echo base_url('contact') ?>"> <?php echo trans('contact') ?>
                            </a>
                        <a class="btn btn-primary btn-sm mt-2" href="<?php echo base_url() ?>"><i
                                class="icon-home"></i> <?php echo trans('home') ?> </a>
                    </div>
                <?php else: ?>

                <div class="text-center">
                    <h3 class="mb-0 custom-font"><?php echo trans('sign-up') ?></h3>
                    <p class="mb-0"><?php echo trans('create-an-account') ?></p>
                </div>

                <div class="mt-5 px-7 row">
                    <div class="col-md-6 px-0 d-flex align-items-center">
                        <span class="btn btn-primary py-2 mentor_register_btn mb-2 btn-block"><i class="bi bi-person-workspace"></i> <?php echo trans('mentor') ?></span>
                    </div>

                    <div class="col-md-6 px-0 pl-md-2 d-flex align-items-center">
                        <span class="btn py-2 border-1 mentee_register_btn mb-2 btn-block"><i class="bi bi-person-badge"></i> <?php echo trans('mentee') ?></span>
                    </div>
                </div>

                <div class="mb-4 mt-4 pl-5">
                    <div class="success text-success"></div>
                    <div class="success_extend text-success"></div>
                    <div class="error text-danger"></div>
                    <div class="warning text-warning"></div>
                </div>

                <form id="register_form" class="authorization__form authorization__form--shadow leave_con px-5" method="post"
                    action="<?php echo base_url('auth/register_user'); ?>">

                    <div class="row">
                        
                        <div class="col-12 mt-2">
                            <div class="form-group">
                                <label class="mb-1"><?php echo trans('name') ?> <span class="text-danger">*</span></label>
                                <input type="text" required class="form-control" name="name">
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="form-group">
                                <label class="mb-1"><?php echo trans('email') ?> <span class="text-danger">*</span></label>
                                <input type="email" class="form-control" name="email" placeholder="" required>
                            </div>
                        </div>
                       
                        <div class="col-12">
                            <div class="form-group"> 
                                <label class="mb-1"><?php echo trans('phone') ?> <span class="text-danger">*</span></label>
                                <input type="phone" class="form-control" name="phone" placeholder="" required>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="form-group">
                                <label class="mb-1"><?php echo trans('password') ?> <span class="text-danger">*</span></label>
                                <input type="password" class="form-control" name="password" required>
                            </div>
                        </div>

                        <div class="col-12 mentor_category">
                            <div class="form-group">
                                <label class="mb-1"><?php echo trans('categories-upto3') ?> <span class="text-danger">*</span></label>
                                <select class="register_category wide w-100 form-control select2" name="category[]" id="rcategory" multiple required >
                                    <option value=""> <?php echo trans('select') ?></option>
                                    <?php foreach ($categories as $category): ?>
                                        <option value="<?php echo html_escape($category->id)?>"> <?php echo html_escape($category->name)?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                         <div class="col-12 mentee_category" style="display:none;">
                            <div class="form-group">
                                <label class="mb-1"><?php echo trans('categories') ?> <span class="text-danger">*</span></label>
                                <select class="mentregister_category wide w-100 form-control select2" name="category[]" id="rcategory">
                                    <option value=""> <?php echo trans('select') ?></option>
                                    <?php 
                                    $mcategories=array('School Student','College Student','Professional','Business owner');
                                    foreach ($mcategories as $key=> $category): ?>
                                        <option value="<?php echo html_escape($key)?>"> <?php echo html_escape($category)?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-12 mentor_skill">
                            <div class="form-group">
                                <label><?php echo trans('skills') ?><span class="text-danger">*</span></label>
                                <select class="form-control select2" name="skills[]" id="register_skills" multiple required>                
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6 linkedin">
                            <div class="form-group mb-4">
                                <label><?php echo trans('linkedin-profile') ?></label>
                                <input class="form-control" type="text" name="linkedin_profile" value="" autocomplete="off" aria-invalid="false">
                            </div>
                        </div>
                        <div class="col-md-6 experience">
                            <div class="form-group mb-4">
                                <label><?php echo trans('experience') ?><span class="text-danger">*</span></label>
                                <select class="form-control" name="experience_year" required id="experience_year">
                                    <option value=""><?php echo trans('select-your-experience') ?></option>
                                    <?php for ($i=1 ; $i <31; $i++ ): ?>
                                        <option value="<?php echo html_escape($i); ?>" <?php if(isset($user->experience_year) && $user->experience_year == $i){echo 'selected';} ?>><?php echo html_escape($i); ?> Year</option>
                                        
                                    <?php endfor; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <label><?php echo trans('country') ?> <span class="text-danger">*</span></label>
                                <select class="form-control select2" name="country" required>
                                     <!-- <option value=""><?php //echo trans('select') ?></option> -->
                                    <?php foreach ($countries as $country): ?>
                                        <option value="<?php echo html_escape($country->id) ?>"><?php echo html_escape($country->name) ?></option>
                                    <?php endforeach ?>                 
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-6">
                            <div class="form-group">
                                <label><?php echo trans('time-zone') ?> <span class="text-danger">*</span></label>
                                <select class="form-control select2" name="time_zone" required>
                                     <!-- <option value=""><?php //echo trans('select') ?></option> -->
                                    <?php foreach ($time_zones as $time): 
                                        $select='';
                                        if($time->id == 194){
                                            $select="selected";
                                        }
                                        ?>
                                      <option value="<?php echo html_escape($time->id) ?>" <?php echo $select; ?>><?php echo html_escape($time->name) ?></option>
                                    <?php endforeach ?>                  
                                </select>
                            </div>
                        </div>

                    </div>


                    <div class="row mt-2">
                        <div class="col-md-12">
                            <?php if (settings()->enable_captcha == 1 && settings()->captcha_site_key != ''): ?>
                            <div class="g-recaptcha pull-left"
                                data-sitekey="<?php echo html_escape(settings()->captcha_site_key); ?>"></div>
                            <?php endif ?>
                        </div>
                    </div>


                    <div class="row mt-2">
                        <div class="col-12">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" name="agree" class="custom-control-input agree_btn"
                                    id="terms-condition" required>
                                <label class="custom-control-label" for="terms-condition">
                                    <?php echo trans('i-have-read-and-understood-the') ?> 
                                    <a class="text-primary" target="_blank" href="<?php echo base_url('page/terms-and-condition') ?>"><?php echo trans('terms-and-conditions') ?></a>
                                    <?php echo trans('and') ?> 

                                    <a class="text-primary" target="_blank" href="<?php echo base_url('page/privacy-policy') ?>"> <?php echo trans('privacy-policy') ?> </a><?php echo trans('of-this-site') ?>.
                                </label>
                            </div>
                        </div>

                        <div class="col-md-12 center">
                            <input type="hidden" name="register_type" value="1" class="register_type">
                            <input type="hidden" name="plan"
                                value="<?php if(isset($_GET['plan'])){echo html_escape($_GET['plan']);}else{echo "basic";} ?>">
                            <input type="hidden" name="billing"
                                value="<?php if(isset($_GET['billing'])){echo html_escape($_GET['billing']);}else{echo "monthly";} ?>">
                            <input type="hidden" name="<?php echo html_escape($this->security->get_csrf_token_name());?>"
                                value="<?php echo html_escape($this->security->get_csrf_hash());?>">
                            <button type="submit" class="btn btn-primary btn-block mt-4 mb-0 register_button">
                                <?php echo trans('register') ?>
                            </button>
                        </div>

                        <?php if (get_system_settings('enable_google') == 1): ?>
                            <div class="col-md-12 center">
                                    <div class="py-3 w-50 m-auto or"><span>or</span></div>
                            </div>
                        <?php endif ?>

            
                        <?php if($google_url && get_system_settings('enable_google') == 1): ?>
                            <div class="col-md-12 center">
                                <div class="form-group mb-3">
                                    <a href="#" data-toggle="modal" data-target="#googleAuthModal" class="btn btn-block w-100 d-flex align-items-center justify-content-center" style="gap: 10px;background: #F1F1F1;padding:0.5rem 1.5rem!important;">
                                        <svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 48 48" width="35px" height="35px" style="width:unset;"><path fill="#FFC107" d="M43.611,20.083H42V20H24v8h11.303c-1.649,4.657-6.08,8-11.303,8c-6.627,0-12-5.373-12-12c0-6.627,5.373-12,12-12c3.059,0,5.842,1.154,7.961,3.039l5.657-5.657C34.046,6.053,29.268,4,24,4C12.955,4,4,12.955,4,24c0,11.045,8.955,20,20,20c11.045,0,20-8.955,20-20C44,22.659,43.862,21.35,43.611,20.083z"/><path fill="#FF3D00" d="M6.306,14.691l6.571,4.819C14.655,15.108,18.961,12,24,12c3.059,0,5.842,1.154,7.961,3.039l5.657-5.657C34.046,6.053,29.268,4,24,4C16.318,4,9.656,8.337,6.306,14.691z"/><path fill="#4CAF50" d="M24,44c5.166,0,9.86-1.977,13.409-5.192l-6.19-5.238C29.211,35.091,26.715,36,24,36c-5.202,0-9.619-3.317-11.283-7.946l-6.522,5.025C9.505,39.556,16.227,44,24,44z"/><path fill="#1976D2" d="M43.611,20.083H42V20H24v8h11.303c-0.792,2.237-2.231,4.166-4.087,5.571c0.001-0.001,0.002-0.001,0.003-0.002l6.19,5.238C36.971,39.205,44,34,44,24C44,22.659,43.862,21.35,43.611,20.083z"/>
                                        </svg> 
                                        <span>Continue with Google</span>
                                    </a>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>


                    <div class="text-center text-small mt-4">
                        <span><?php echo trans('already-have-an-account') ?> <a href="<?php echo base_url('login') ?>"><?php echo trans('sign-in') ?></a></span>
                    </div>

                </form>
                
                <?php endif ?>

            </div>
        </div>
    </div>
    <!-- End register form -->
    <?php endif; ?>

    <?php if (isset($page_title) && $page_title == 'Email Verification'): ?>
    <!-- email verify -->
    <div class="container">
        <div class="row justify-content-center justify-content-lg-start">
            <div class="col-md-8 col-lg-7 col-xl-5 offset-lg-2 offset-xl-3 my-5" data-aos="fade-down" data-aos-duration="400">
                    <?php $verify_type = $_GET['type']; ?>
         
                    <div class="mb-3 text-center">
                        <img class="mb-4" width="30%" src="<?php echo base_url('assets/front/img/message.png') ?>">
                        <p><?php echo trans('we-have-send-a-verification-code-in-your') ?> <?php if($verify_type == 'sms'){echo trans('phone');}else{echo trans('email');} ?>.</p>
                    </div>

                    <form id="verify_from" method="post" action="<?php echo base_url('auth/verify_account'); ?>">

                        <div class="row justify-content-center">
                            <div class="col-6 mb-2">
                                <div class="form-group">
                                    <input type="text" class="form-control text-center" name="code" placeholder="<?php echo trans('enter-code-here') ?>">
                                </div>
                            </div>
                        </div>

                        <div class="row justify-content-center">
                            <div class="col-6">
                                <input type="hidden" name="type" value="<?php echo html_escape($verify_type) ?>">
                                <input type="hidden" name="user" value="<?php echo html_escape($_GET['user']) ?>">
                                <input type="hidden" name="<?php echo html_escape($this->security->get_csrf_token_name());?>" value="<?php echo html_escape($this->security->get_csrf_hash());?>">
                                <button type="submit" class="btn btn-success btn-block mb-0 verify_btn"><i class="fas fa-check-circle"></i> <?php echo trans('verify-code') ?></button>
                            </div>
                        </div>


                        <div class="loader mb-2 mt-4 text-primary text-center hide"><?php echo trans('sending') ?> <i class="fa fa-spinner fa-spin"></i></div>

                        <div class="text-center text-small mt-2">
                            <?php if ($verify_type == 'sms'): ?>
                                <span><?php echo trans('dont-received-any-code') ?><a class="resend_mail" href="<?php echo base_url('auth/resend_sms') ?>"><?php echo trans('resend') ?></a></span>
                            <?php else: ?>
                                <span><?php echo trans('dont-received-any-code') ?><a class="resend_mail" href="<?php echo base_url('auth/resend') ?>"><?php echo trans('resend') ?></a></span>
                            <?php endif ?>

                            <p><a class="btn btn-light-secondary btn-sm mt-2" href="<?php echo base_url() ?>"><i
                                class="fas fa-long-arrow-alt-left"></i> <?php echo trans('back') ?> </a></p>
                        </div>

                    </form>

            </div>
        </div>
    </div>
    <!-- End email verify -->
    <?php endif ?>
</div>

<div class="modal fade" id="googleAuthModal" tabindex="-1" role="dialog" aria-labelledby="googleAuthModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content border-0 shadow">
      <div class="modal-header border-0 py-3">
        <h5 class="modal-title" id="googleAuthModalLabel"><?php echo trans('choose_account_type') ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true"><i class="bi bi-x"></i></span>
        </button>
      </div>
      <div class="modal-body py-4">
        <p class="text-center text-muted mb-4"><?php echo trans('select') ?> <?php echo trans('account') ?> <?php echo trans('type') ?> <?php echo trans('to_continue') ?></p>
        
        <div class="row justify-content-center mb-4">
          <div class="col-md-5 mb-3">
            <div class="account-option" id="option-mentor">
              <input type="radio" id="account-mentor" name="account_type_modal" value="mentor" class="account-radio">
              <label for="account-mentor" class="account-label">
                <div class="icon-wrapper mb-3">
                  <i class="bi bi-person-workspace"></i>
                </div>
                <h6 class="mb-2"><?php echo trans('mentor') ?></h6>
                <p class="text-muted small mb-0">I want to provide mentoring and guidance</p>
              </label>
            </div>
          </div>
          <div class="col-md-5 mb-3">
            <div class="account-option" id="option-mentee">
              <input type="radio" id="account-mentee" name="account_type_modal" value="mentee" class="account-radio">
              <label for="account-mentee" class="account-label">
                <div class="icon-wrapper mb-3">
                  <i class="bi bi-person-badge"></i>
                </div>
                <h6 class="mb-2"><?php echo trans('mentee') ?></h6>
                <p class="text-muted small mb-0">I'm looking for guidance and mentorship</p>
              </label>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer border-0 justify-content-center pb-4">
        <a href="#" id="google_continue_btn" class="btn btn-primary btn-lg px-5 disabled">
          <div class="d-flex align-items-center">
            <span><?php echo trans('continue') ?></span>
            <i class="bi bi-arrow-right-short ml-2"></i>
          </div>
        </a>
      </div>
    </div>
  </div>
</div>

<style>
.account-option {
  position: relative;
  height: 100%;
}

.account-radio {
  position: absolute;
  opacity: 0;
  width: 0;
  height: 0;
}

.account-label {
  display: block;
  border: 2px solid #e9ecef;
  border-radius: 12px;
  padding: 1.5rem;
  cursor: pointer;
  transition: all 0.25s ease;
  text-align: center;
  height: 100%;
}

.icon-wrapper {
  font-size: 2rem;
  display: flex;
  align-items: center;
  justify-content: center;
  color: var(--primary-color);
}

.account-radio:checked + .account-label {
  border-color: var(--primary-color);
  background-color: rgba(var(--primary-rgb), 0.05);
  box-shadow: 0 0 0 3px rgba(var(--primary-rgb), 0.2);
  transform: translateY(-3px);
}

#google_continue_btn.disabled {
  opacity: 0.6;
  cursor: not-allowed;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
  const accountOptions = document.querySelectorAll('.account-radio');
  const continueBtn = document.getElementById('google_continue_btn');
  
  accountOptions.forEach(option => {
    option.addEventListener('change', function() {
      continueBtn.classList.remove('disabled');
      
      document.querySelectorAll('.account-option').forEach(opt => {
        opt.classList.remove('selected');
      });
      this.closest('.account-option').classList.add('selected');
    });
  });
  
  continueBtn.addEventListener('click', function(e) {
    e.preventDefault();
    
    if (this.classList.contains('disabled')) {
      return false;
    }
    
    const selectedType = document.querySelector('input[name="account_type_modal"]:checked');
    if (!selectedType) {
      return false;
    }
    
    this.innerHTML = '<div class="d-flex align-items-center"><span><?php echo trans('loading') ?>...</span><div class="spinner-border spinner-border-sm ml-2" role="status"><span class="sr-only">Loading...</span></div></div>';
    this.classList.add('disabled');
    
    const xhr = new XMLHttpRequest();
    xhr.open('GET', '<?php echo base_url() ?>auth/add_account_type/' + selectedType.value, true);
    xhr.onload = function() {
      if (xhr.status === 200) {
        window.location.href = '<?php echo $google_url ?>';
      }
    };
    xhr.send();
  });
});
</script>
