<style>
    .profile-header {
        position: relative;
        height: 250px;
        background-size: cover;
        background-position: center;
    }
    
    .profile-container {
        position: relative;
        margin-top: -100px;
    }
    
    .profile-avatar {
        width: 180px;
        height: 180px;
        border: 5px solid #fff;
        box-shadow: 0 10px 25px rgba(0,0,0,0.1);
    }
    
    .mentor-sidebar {
        background: #fff;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.05);
        transition: all 0.3s ease;
    }
    
    .mentor-sidebar:hover {
        box-shadow: 0 8px 30px rgba(0,0,0,0.08);
    }
    
    .sidebar-badge {
        display: inline-flex;
        align-items: center;
        background: #f1f5f9;
        padding: 6px 14px;
        border-radius: 20px;
        font-size: 0.85rem;
        font-weight: 500;
        color: #475569;
        margin-right: 8px;
        margin-bottom: 8px;
        transition: all 0.2s ease;
    }
    
    .sidebar-badge:hover {
        background: #e2e8f0;
        transform: translateY(-2px);
    }
    
    .sidebar-badge i {
        margin-right: 5px;
        color: #2563eb;
    }
    
    .session-card {
        border-radius: 12px;
        transition: all 0.3s ease;
        cursor: pointer;
        border: 2px solid transparent;
    }
    
    .session-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.08);
    }
    
    .session-card.selected {
        border-color: var(--primary-color);
    }
    
    .stats-card {
        border-radius: 12px;
        transition: all 0.3s ease;
        height: 100%;
        display: flex;
        align-items: center;
    }
    
    .stats-card:hover {
        transform: translateY(-3px);
    }
    
    .stat-icon {
        width: 40px;
        height: 40px;
        min-width: 40px;
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 10px;
        font-size: 18px;
    }

    .experience-card {
        position: relative;
        padding-left: 30px;
    }
    
    .experience-card::before {
        content: '';
        position: absolute;
        left: 15px;
        top: 0;
        bottom: 0;
        width: 2px;
        background: rgba(0,0,0,0.1);
    }
    
    .experience-icon {
        background: #fff;
        width: 30px;
        height: 30px;
        border-radius: 50%;
        box-shadow: 0 3px 10px rgba(0,0,0,0.1);
        display: flex;
        align-items: center;
        justify-content: center;
        position: absolute;
        left: 0;
        top: 0;
        z-index: 1;
    }
    
    .similar-mentor-card {
        border-radius: 12px;
        transition: all 0.3s ease;
        height: 100%;
    }
    
    .similar-mentor-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 30px rgba(0,0,0,0.1);
    }
    
    .similar-mentor-img {
        height: 80px;
        width: 80px;
        border-radius: 50%;
        object-fit: cover;
        border: 3px solid #fff;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }

    .review-card {
        border-radius: 12px;
        transition: all 0.3s ease;
    }
    
    .review-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 10px 30px rgba(0,0,0,0.08);
    }
    
    .review-avatar {
        width: 60px;
        height: 60px;
        border-radius: 50%;
        object-fit: cover;
    }
    
@media (max-width: 768px) {
        .profile-header {
            height: 180px;
        }
        
        .profile-container {
            margin-top: -70px;
        }
        
        .profile-avatar {
            width: 140px;
            height: 140px;
        }
    }

    .content-card {
        border-radius: 12px;
        border: none;
        background: #fff;
        box-shadow: 0 5px 15px rgba(0,0,0,0.05);
        transition: all 0.3s ease;
        overflow: hidden;
    }

    .content-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px rgba(0,0,0,0.1);
    }

    .content-card-header {
        padding: 1.25rem 1.5rem;
        border-bottom: 1px solid #f1f5f9;
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    .content-card-body {
        padding: 1.5rem;
    }

    .badge-primary{
        background-color: var(--primary-color);
        color: #fff!important;
    }
</style>

<!-- Profile Cover -->
<div class="profile-header" style="background-image: url(<?php if (empty($mentor->cover)) {
    echo base_url('assets/front/img/vericla-cover.jpg');
} else {
    echo base_url($mentor->cover);
} ?>)"></div>

<div class="container profile-container">
        <div class="row">
        <div class="col-lg-8">
            <!-- Profile Header Information -->
            <div class="bg-white p-4 mb-4 shadow-sm" style="border-radius: 15px;">
                <div class="d-flex flex-wrap">
                    <div class="mr-4 mb-3 position-relative">
                        <div class="profile-avatar rounded-circle" style="background-image: url(<?php echo base_url($mentor->image) ?>); background-size: cover; background-position: center;">
                            <?php if ($mentor->kyc_verified == 1): ?>
                                    <div class="position-absolute" style="top: 10px; right: 5px;">
                                        <img width="40px" class="rounded-circle p-1" src="<?php echo base_url('assets/images/approved.png') ?>" alt="Verified">
                                    </div>
                            <?php endif; ?>
                        </div>
                    </div>
                
                    <div class="flex-grow-1">
                        <div class="d-flex align-items-center flex-wrap mb-2">
                            <h1 class="h2 font-weight-bold mb-0 mr-2"><?php echo html_escape($mentor->name) ?></h1>
                        <?php $code = get_by_id($mentor->country, 'country')->code; ?>
                            <img data-toggle="tooltip" data-placement="top" title="<?php echo get_by_id($mentor->country, 'country')->name; ?>" class="ml-2" width="24" src="<?php echo base_url('assets/images/flags/' . strtolower($code) . '.png') ?>" alt="Country Flag">
                        </div>
                       
                        <p class="text-muted mb-2">
                            <strong><?php echo html_escape($mentor->designation) ?></strong>
                        <?php if (!empty($mentor->company)): ?>
                                    at <span class="font-weight-bold"><?php echo html_escape($mentor->company) ?></span>
                        <?php endif ?>
                        </p>
                        
                        <p class="mb-2">
                            <i class="bi bi-geo-alt text-primary mr-2"></i>
                            <?php echo get_by_id($mentor->country, 'country')->name ?>
                        </p>
                        
                        <?php
                        if ($mentor->is_active == 0) {
                            if (isset($mentor->last_logout) && $mentor->last_logout != "NULL" && $mentor->last_logout != NULL && $mentor->last_logout != "") {
                                $ltime = $mentor->last_logout;
                            } else {
                                $ltime = date("Y-m-d H:i:s", strtotime("-20 hours"));
                            }
                            $active_text = get_time_ago($ltime);
                        } else {
                            $active_text = 'now';
                        }
                        ?>

                        <p class="mb-2">
                            <i class="bi bi-clock text-primary mr-2"></i>
                            Active <span class="font-weight-bold"><?php echo html_escape($active_text) ?></span>
                        </p>

                        <?php
                        if ($mentor->respond_in == 'day') {
                            if ($mentor->respond_time > 1) {
                                $text = 'days';
                            } else {
                                $text = 'day';
                            }
                        } else {
                            if ($mentor->respond_time > 1) {
                                $text = 'hours';
                            } else {
                                $text = 'hour';
                            }
                        }
                        ?>

                        <p class="mb-3">
                            <i class="bi bi-lightning-charge-fill text-warning mr-2"></i>
                            Usually responds in <span class="font-weight-bold"><?php echo html_escape($mentor->respond_time) ?> <?php echo html_escape($text); ?></span>
                        </p>

                        <!-- Social Media Links -->
                        <div class="d-flex align-items-center mt-3">
                                <?php if (!empty($mentor->facebook_profile)): ?>
                                    <a href="<?= prep_url($mentor->facebook_profile) ?>" target="_blank" class="text-secondary mr-3">
                                        <i class="bi bi-facebook fs-20"></i>
                                    </a>
                                <?php endif ?>

                                <?php if (!empty($mentor->x_profile)): ?>
                                    <a href="<?= prep_url($mentor->x_profile) ?>" target="_blank" class="text-secondary mr-3">
                                        <i class="bi bi-twitter fs-20"></i>
                                    </a>
                                <?php endif ?>

                                <?php if (!empty($mentor->linkedin_profile)): ?>
                                    <a href="<?= prep_url($mentor->linkedin_profile) ?>" target="_blank" class="text-secondary mr-3">
                                        <i class="bi bi-linkedin fs-20"></i>
                                    </a>
                                <?php endif ?>

                                <?php if (!empty($mentor->instagram_profile)): ?>
                                    <a href="<?= prep_url($mentor->instagram_profile) ?>" target="_blank" class="text-secondary mr-3">
                                        <i class="bi bi-instagram fs-20"></i>
                                    </a>
                                <?php endif ?>
                </div>
            </div>

                    <div class="ml-auto d-flex align-items-start">
                <?php if (check_auth() == TRUE): ?>
                        <?php if (is_mentee() || is_user()): ?>
                                <?php if ($this->session->userdata('id') != $mentor->id): ?>
                                                <a href="#" data-toggle="modal" data-target="#send_message" class="btn btn-outline-primary mr-2">
                                                    <i class="bi bi-chat-dots mr-1"></i> Message
                                                </a>
                                <?php endif; ?>
                        <?php endif; ?>
                <?php else: ?>
                                <a href="<?php echo base_url('login') ?>" class="btn btn-outline-primary mr-2">
                                    <i class="bi bi-chat-dots mr-1"></i> Message
                                </a>
                <?php endif; ?>

                <!-- <?php $favourite = check_favourite($mentor->id, $this->session->userdata('id')) ?>
                <?php if (check_auth() == TRUE): ?>
                        <?php if ($this->session->userdata('id') != $mentor->id): ?>
                                        <a href="#" class="btn <?php if (empty($favourite)) {
                                            echo 'btn-outline-primary';
                                        } else {
                                            echo 'btn-primary';
                                        } ?> add_favourite">
                                            <i class="bi bi-heart<?php if (!empty($favourite)) {
                                                echo '-fill';
                                            } ?>"></i>
                                        </a>

                                <input type="hidden" class="favourite_id" value="<?php echo html_escape($mentor->id) ?>" name="favourite_id">
                                <input type="hidden" class="user_id" value="<?php echo html_escape($this->session->userdata('id')) ?>" name="user_id">
                        <?php endif; ?>
                <?php else: ?>
                                <a href="<?php echo base_url('login') ?>" class="btn btn-outline-primary">
                                    <i class="bi bi-heart"></i>
                                </a>
                <?php endif; ?> -->
                    </div>
                </div>
            </div>

            <div class="p-4 mb-4">
                <ul class="nav border-0" id="mentorProfileTabs" role="tablist">
                        <li class="nav-item">
                        <a class="nav-link active" id="overview-tab" data-toggle="tab" href="#overview" role="tab">
                            Overview
                        </a>
                        </li>
                        <li class="nav-item">
                        <a class="nav-link" id="reviews-tab" data-toggle="tab" href="#reviews" role="tab">
                            Reviews 
                                <?php if ($total_rating): ?>
                                    (<?php echo html_escape($total_rating) ?>)
                                <?php endif; ?>
                            </a>
                        </li>
                    </ul>
                </div>
            
            <!-- Tab Contents -->
            <div class="tab-content" id="mentorProfileTabContent">
                <!-- Overview Tab -->
                <div class="tab-pane fade show active" id="overview" role="tabpanel" aria-labelledby="overview-tab">
                    <!-- Update About Section -->
                    <div class="content-card mb-4">
                        <div class="content-card-header">
                            <h3 class="h5 font-weight-bold mb-0">About</h3>
            </div>
                        <div class="content-card-body">
                            <?php $mentor_lang = get_mentor_by_language($mentor->id); ?>
                            <?php if (!empty($mentor_lang->about)): ?>
                                    <p class="text-muted mb-0"><?php echo html_escape($mentor_lang->about) ?></p>
                            <?php else: ?>
                                    <p class="text-muted mb-0">No information provided.</p>
                            <?php endif ?>
                        </div>
                    </div>

                    <!-- Introduction Video -->
                                <?php if (!empty($mentor->intro_video)): ?>
                            <div class="bg-white p-4 mb-4 rounded-lg shadow-sm">
                                <h3 class="h5 font-weight-bold mb-3">Introduction Video</h3>
                                <div class="embed-responsive embed-responsive-16by9 rounded">
                                    <iframe class="embed-responsive-item" src="<?php echo prep_url($mentor->intro_video) ?>" allowfullscreen></iframe>
                                            </div>
                                        </div>
                                <?php endif ?> 

                    <!-- Update Skills Section -->
                    <div class="content-card mb-4">
                        <div class="content-card-header">
                            <h3 class="h5 font-weight-bold mb-0">Skills</h3>
                                </div>
                        <div class="content-card-body">
                            <div class="d-flex flex-wrap">
                                <?php foreach ($skills as $skill): ?>
                                        <?php $skill_id = $skill['skill_id']; ?>
                                        <span class="sidebar-badge">
                                            <i class="bi bi-check-circle text-primary"></i>
                                            <?php echo get_by_id($skill_id, 'skills')->skill; ?>
                                        </span>
                                            <?php endforeach ?>
                            </div>
                                                    </div>
                                                </div>

                    <!-- Update Languages Section -->
                    <div class="content-card mb-4">
                        <div class="content-card-header">
                            <h3 class="h5 font-weight-bold mb-0">Languages</h3>
                                            </div>
                        <div class="content-card-body">
                            <div class="d-flex flex-wrap">
                                <?php $languages = explode(",", $mentor->language); ?>
                                <?php foreach ($languages as $language): ?>
                                        <span class="sidebar-badge">
                                            <i class="bi bi-translate text-primary"></i>
                                            <?php echo html_escape($language) ?>
                                        </span>
                                        <?php endforeach ?>
                                    </div>
                                </div>
                                    </div>

                    <!-- Experience Section -->
                    <?php if (!empty($experiences)): ?>
                            <div class="bg-white p-4 mb-4 shadow-sm" style="border-radius: 15px;">
                                <h3 class="h5 font-weight-bold mb-4">Experience</h3>
                                <div class="position-relative">
                                    <?php foreach ($experiences as $index => $experience): ?>
                                            <div class="experience-card mb-4 pb-4">
                                                <div class="experience-icon">
                                                    <i class="<?php echo html_escape(!empty($experience->icon) ? $experience->icon : 'fas fa-briefcase'); ?> text-primary"></i>
                                                </div>
                                                <h4 class="h6 font-weight-bold mb-1"><?php echo html_escape($experience->title) ?></h4>
                                                <p class="text-muted mb-2">
                                                    <?php echo html_escape($experience->company) ?>
                                                    <span class="d-block text-muted small">
                                                        <?php echo my_date_show($experience->start_date); ?> - 
                                                        <?php if ($experience->is_present == 1) {
                                                            echo 'Present';
                                                        } else {
                                                            echo my_date_show($experience->end_date);
                                                        } ?>
                                </span>
                                                </p>
                                                <p class="text-muted small mb-0"><?php echo html_escape($experience->contribution) ?></p>
            </div>
                                    <?php endforeach ?>
                                </div>
                            </div>
                    <?php endif; ?>
                    
                    <!-- Education Section -->
                    <?php if (!empty($educations)): ?>
                            <div class="bg-white p-4 mb-4 shadow-sm" style="border-radius: 15px;">
                                <h3 class="h5 font-weight-bold mb-4">Education</h3>
                                <div class="position-relative">
                                    <?php foreach ($educations as $education): ?>
                                            <div class="experience-card mb-4 pb-4">
                                                <div class="experience-icon">
                                                    <i class="bi bi-mortarboard text-primary"></i>
                                                </div>
                                                <h4 class="h6 font-weight-bold mb-1"><?php echo html_escape($education->institute) ?></h4>
                                                <p class="text-muted mb-0">
                                                    <?php echo html_escape($education->degree) ?>
                                                    <span class="d-block text-muted small">
                                                        <?php echo html_escape($education->start_year) ?> - <?php echo html_escape($education->end_year) ?>
                                                    </span>
                                                </p>
                                            </div>
                                    <?php endforeach ?>
                                                </div>
                                            </div>
                    <?php endif; ?>
                    
                    <!-- Similar Mentors Section -->
                    <?php
                    $similar_mentors = $this->common_model->get_similar_mentors($mentor->category, $mentor->id);
                    if (!empty($similar_mentors)):
                        ?>
                            <div class="p-4 mb-4">
                                <h3 class="h5 font-weight-bold mb-4">Similar Mentors</h3>
                                <div class="row">
                                    <?php foreach ($similar_mentors as $similar_mentor): ?>
                                            <div class="col-md-6 mb-4">
                                                <a href="<?php echo base_url('mentor/' . $similar_mentor->slug) ?>" class="text-decoration-none">
                                                    <div class="similar-mentor-card p-3 bg-white shadow-sm">
                                                        <div class="d-flex">
                                                            <?php if (empty($similar_mentor->image)): ?>
                                                                    <?php $mentor_img = base_url('assets/images/no-photo-sm.png'); ?>
                                                            <?php else: ?>
                                                                    <?php $mentor_img = base_url($similar_mentor->image); ?>
                                                            <?php endif ?>
                                                            <img src="<?php echo $mentor_img; ?>" alt="<?php echo html_escape($similar_mentor->name); ?>" class="similar-mentor-img mr-3">
                                                    
                                                            <div>
                                                                <h4 class="h6 font-weight-bold mb-1"><?php echo html_escape($similar_mentor->name); ?></h4>
                                                                <p class="text-muted small mb-2">
                                                                    <?php if (!empty($similar_mentor->designation)): ?>
                                                                            <?php echo html_escape($similar_mentor->designation) ?>
                                                                            <?php if (!empty($similar_mentor->company)): ?>
                                                                                    at <?php echo html_escape($similar_mentor->company) ?>
                                                                            <?php endif ?>
                                                            <?php endif ?>
                                                        </p>
                                                        
                                                                <div class="d-flex align-items-center">
                                                                    <?php $code = get_by_id($similar_mentor->country, 'country')->code; ?>
                                                                    <img width="16" src="<?php echo base_url('assets/images/flags/' . strtolower($code) . '.png') ?>" alt="Flag" class="mr-2">
                                                                    <span class="badge badge-pill badge-light mr-2">
                                                                        <?php echo html_escape($similar_mentor->experience_year); ?> years
                                                                                </span>
                                                                    <?php if ($similar_mentor->minprice > 0 || $similar_mentor->maxprice > 0): ?>
                                                                            <span class="badge badge-pill badge-primary">
                                                                                <?php echo settings()->currency_symbol . ' ' . $similar_mentor->minprice . ' - ' . $similar_mentor->maxprice; ?>
                                                                            </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                </div>
                                                        </div>
                                                    </div>
                                                </a>
                                                </div>
                                    <?php endforeach ?>
                                </div>
                            </div>
                    <?php endif; ?>
                </div>

                <!-- Reviews Tab -->
                <div class="tab-pane fade" id="reviews" role="tabpanel" aria-labelledby="reviews-tab">
                    <div class="bg-white p-4 shadow-sm" style="border-radius: 15px;">
                        <h3 class="h5 font-weight-bold mb-4">Client Reviews</h3>
                        
                        <?php if (!empty(get_all_ratings($mentor->id))): ?>
                                <?php foreach (get_all_ratings($mentor->id) as $value): ?>
                                        <div class="review-card p-3 mb-4 bg-light rounded">
                                            <div class="d-flex">
                                                    <?php if (empty($value->mentee_thumb)): ?>
                                                            <?php $mentee_thumb = base_url('assets/images/no-photo-sm.png'); ?>
                                                    <?php else: ?>
                                                            <?php $mentee_thumb = base_url($value->mentee_thumb); ?>
                                                    <?php endif ?>
                                                
                                                <img src="<?php echo $mentee_thumb ?>" alt="Reviewer" class="review-avatar mr-3">

                                                <div>
                                                    <h4 class="h6 font-weight-bold mb-1"><?php echo html_escape($value->mentee_name) ?></h4>

                                                    <div class="mb-2">
                                                    <?php if (!empty($value->rating)): ?>
                                                          <?php for ($u = 1; $u <= 5; $u++): ?>
                                                                <?php
                                                                if (round($value->rating - .25) >= $u) {
                                                                    $star = "fas fa-star";
                                                                } elseif (round($value->rating + .25) >= $u) {
                                                                    $star = "fas fa-star-half-alt";
                                                                } else {
                                                                    $star = "far fa-star";
                                                                }
                                                                ?>
                                                                        <i class="<?php echo html_escape($star); ?> text-warning"></i> 
                                                          <?php endfor; ?>
                                                    <?php endif ?> 
                                                    </div>
                                            
                                                    <p class="text-muted mb-0"><?php echo html_escape($value->feedback) ?></p>
                                                </div>
                                            </div>
                                        </div>
                                <?php endforeach ?>
                        <?php else: ?>
                                <div class="text-center py-5">
                                    <i class="bi bi-star text-muted display-4"></i>
                                    <p class="mt-3 text-muted">No reviews yet</p>
                                </div>
                        <?php endif ?>
                    </div>
                </div>
            </div>
            
            <!-- Blog Posts -->
            <?php if (!empty($blogs)): ?>
                    <div class="mt-4">
                        <div class="d-flex align-items-center justify-content-between mb-4">
                            <h3 class="h5 font-weight-bold mb-0">Latest Articles</h3>
                            <a href="#" class="text-primary">View all</a>
                        </div>
                    
                        <div class="row">
                            <?php foreach ($blogs as $blog): ?>
                                    <div class="col-md-4 mb-4">
                                        <div class="card h-100 border-0 shadow-sm">
                                            <a href="<?php echo base_url('post/' . $mentor->slug . '/' . $blog->slug) ?>">
                                                <img src="<?php echo base_url($blog->image) ?>" class="card-img-top" alt="<?php echo html_escape($blog->title) ?>">
                                            </a>
                                            <div class="card-body">
                                                <p class="text-muted small mb-2"><?php echo my_date_show($blog->created_at) ?></p>
                                                <h4 class="h6 font-weight-bold mb-3">
                                                    <a href="<?php echo base_url('post/' . $mentor->slug . '/' . $blog->slug) ?>" class="text-dark">
                                                        <?php echo html_escape($blog->title) ?>
                                                    </a>
                                                </h4>
                                                <a href="<?php echo base_url('post/' . $mentor->slug . '/' . $blog->slug) ?>" class="text-primary small">
                                                    Read more <i class="bi bi-arrow-right ml-1"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                            <?php endforeach ?>
                        </div>
                    </div>
            <?php endif; ?>
        </div>

        <div class="col-lg-4">
            <!-- Sidebar -->
            <div class="mentor-sidebar p-4 mb-4">
                <h3 class="h5 font-weight-bold mb-4">Community Statistics</h3>
                
                <div class="row">
                    <div class="col-6 mb-4">
                        <div class="stats-card p-3 bg-light rounded">
                            <div class="stat-icon bg-danger-soft mr-3">
                                <i class="bi bi-view-list text-danger"></i>
                            </div>
                            <div>
                                <h4 class="h6 font-weight-bold mb-0"><?php echo get_count_completed_sessions($mentor->id) ?></h4>
                                <p class="text-muted small mb-0">Completed Sessions</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-6 mb-4">
                        <div class="stats-card p-3 bg-light rounded">
                            <div class="stat-icon bg-success-soft mr-3">
                                <i class="bi bi-clock text-success"></i>
                            </div>
                            <div>
                                <h4 class="h6 font-weight-bold mb-0"><?php echo get_count_minute_by_user($mentor->id) ?></h4>
                                <p class="text-muted small mb-0">Total Minutes</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-6 mb-4">
                        <div class="stats-card p-3 bg-light rounded">
                            <div class="stat-icon bg-primary-soft mr-3">
                                <i class="bi bi-person-fill-check text-primary"></i>
                            </div>
                            <div>
                                <h4 class="h6 font-weight-bold mb-0"><?php echo get_user_attendence($mentor->id) ?>%</h4>
                                <p class="text-muted small mb-0">Attendance Rate</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-6 mb-4">
                        <div class="stats-card p-3 bg-light" style="border-radius: 15px;">
                            <div class="stat-icon bg-warning-soft mr-3">
                                <i class="bi bi-mortarboard text-warning"></i>
                            </div>
                            <div>
                                <h4 class="h6 font-weight-bold mb-0">
                                    <?php if (empty($mentor->experience_year)): ?>
                                            1
                                    <?php else: ?>
                                            <?php echo html_escape($mentor->experience_year); ?>
                                    <?php endif ?> years
                                </h4>
                                <p class="text-muted small mb-0">Experience</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Session Booking -->
            <?php if (!empty($sessions)): ?>
                    <div class="mentor-sidebar p-4 mb-4">
                        <h3 class="h5 font-weight-bold mb-4">Book a Session</h3>
                    
                        <?php if ($mentor->booking_enable == 1): ?>
                                <div class="mb-4">
                                    <?php foreach ($sessions as $session): ?>
                                            <div class="session-card p-3 mb-3 bg-light rounded">
                                                <label class="d-flex justify-content-between align-items-center m-0 w-100">
                                                    <input data-id="<?php echo html_escape($session->slug) ?>" type="radio" name="session_id" class="service_input mr-3" id="selected_session" value="<?php echo html_escape($session->id) ?>" required>
                                                    <div class="flex-grow-1">
                                                        <h4 class="h6 font-weight-bold mb-1"><?php echo html_escape($session->name) ?></h4>
                                                        <p class="text-muted small mb-0">
                                                            <i class="bi bi-clock mr-1"></i> <?php echo html_escape($session->duration); ?> minutes
                                                
                                                            <?php if ($session->type == 2): ?>
                                                                    <?php
                                                                    if ($session->session_repeat == 7) {
                                                                        $session_text = 'weekly';
                                                                    } else {
                                                                        $session_text = 'monthly';
                                                                    }
                                                                    ?>
                                                                    <span class="ml-2">Repeats <?php echo html_escape($session_text) ?></span>
                                                                    <span class="ml-2"><?php echo html_escape($session->session_number) ?> Sessions</span>
                                                            <?php endif; ?>
                                                        </p>
                                                    </div>
                                        
                                                    <div class="text-right">
                                                        <span class="badge badge-pill badge-primary">
                                                            <?php if ($session->price != 0): ?>
                                                                    <?php if (settings()->curr_locate == 0) {
                                                                        echo settings()->currency_symbol;
                                                                    } ?>
                                                                    <?php echo number_format($session->price, settings()->num_format) ?>
                                                                    <?php if (settings()->curr_locate == 1) {
                                                                        echo settings()->currency_symbol;
                                                                    } ?>
                                                            <?php else: ?>
                                                                    Free
                                                            <?php endif; ?>
                                                        </span>
                                                    </div>
                                                </label>
                                            </div>
                                
                                            <input type="hidden" name="mentor_id" value="<?php echo html_escape($session->user_id) ?>">
                                    <?php endforeach ?>
                            
                                    <input type="hidden" name="<?php echo html_escape($this->security->get_csrf_token_name()); ?>" value="<?php echo html_escape($this->security->get_csrf_hash()); ?>">
                                </div>
                        
                                <div class="session_details">
                                    <a href="#" class="btn btn-primary btn-block sess_booking_btn disabled">
                                        <i class="bi bi-calendar-check mr-2"></i> Book Now
                                    </a>
                                </div>
                        <?php else: ?>
                                <div class="alert alert-warning" role="alert">
                                    <i class="bi bi-exclamation-circle mr-2"></i> Session booking is currently disabled for this mentor.
                            </div>
                        <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
        </div>
    </div>  

<!-- Send Message Modal -->
<div class="modal fade" id="send_message" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Message to <?php echo html_escape($mentor->name) ?></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true"><i class="bi bi-x"></i></span>
            </button>
        </div>
            
            <form action="<?php echo base_url('home/send_message_mentor') ?>" method="POST">
                <div class="modal-body">
                <div class="form-group">
                        <textarea class="form-control" name="message" placeholder="Write your message here..." rows="5" required></textarea>
                </div>
                <input type="hidden" name="mgs_to" value="<?php echo html_escape($mentor->id) ?>">
                <input type="hidden" name="mgs_from" value="<?php echo html_escape($this->session->userdata('id')) ?>">
            </div>

                <div class="modal-footer">
                <input type="hidden" name="<?php echo html_escape($this->security->get_csrf_token_name()); ?>" value="<?php echo html_escape($this->security->get_csrf_hash()); ?>">
                    <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Send Message</button>
            </div>
        </form>
    </div>
  </div>
</div>

<script>
    $(document).ready(function() {
        // Session selection
        $('.service_input').on('change', function() {
            $('.session-card').removeClass('selected');
            $(this).closest('.session-card').addClass('selected');
            
            var sessionId = $(this).val();
            var sessionSlug = $(this).data('id');
            
            if (sessionId) {
                $('.sess_booking_btn').removeClass('disabled');
                $('.sess_booking_btn').attr('href', '<?php echo base_url('session/') ?>' + sessionSlug);
            } else {
                $('.sess_booking_btn').addClass('disabled');
                $('.sess_booking_btn').attr('href', '#');
            }
        });
        
        // Toggle tooltip
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>
