<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<section class="hero-section position-relative overflow-hidden">
    <div class="container position-relative">
        <div class="row align-items-center">
            <div class="col-lg-6 position-relative z-index-1">
                <div class="toggle-container mb-4">
                    <div class="toggle-wrapper">
                        <input type="checkbox" id="view-toggle" class="toggle-input">
                        <label for="view-toggle" class="toggle-label">
                            <span class="toggle-text toggle-mentee active">Mentee</span>
                            <span class="toggle-handle"></span>
                            <span class="toggle-text toggle-mentor">Mentor</span>
                        </label>
                    </div>
                </div>

                <div id="mentee-content" class="toggle-content active">
                    <h5 class="hero-subtitle-top" data-aos="fade-up" data-aos-delay="100">Accelerate Your Growth with Seasoned Mentor</h5>
                    <h1 class="hero-title" data-aos="fade-up" data-aos-delay="150">Find the Right <span class="text-primary">Mentor</span> for your Big Ideas</h1>
                    
                    <div class="hero-search-container mt-4" data-aos="fade-up" data-aos-delay="200">
                        <form action="<?php echo base_url('mentors'); ?>" method="get" id="hero-search-form">
                            <div class="hero-search-wrapper">
                                <div class="hero-search-icon">
                                    <i class="fas fa-search"></i>
                                </div>
                                <input type="text" name="search" class="hero-search-input" placeholder="Search by keyword, skills or expertise" >
                                <button type="submit" class="hero-search-btn">FIND MENTORS</button>
                            </div>
                        </form>
                    </div>
                    
                    <div class="mentor-categories mt-4" data-aos="fade-up" data-aos-delay="250">
                        <?php 
                        $categories_limit = array_slice($categories, 0, 7);
                        foreach($categories_limit as $category): 
                        ?>
                            <a href="<?php echo base_url('mentors?category='.$category->id) ?>" class="mentor-category-pill">
                                <?php echo html_escape($category->name) ?>
                            </a>
                        <?php endforeach; ?>
                    </div>
                </div>

                <div id="mentor-content" class="toggle-content">
                    <h5 class="hero-subtitle-top" data-aos="fade-up" data-aos-delay="100">JBuild Your Legacy While Empowering Future Innovators</h5>
                    <h1 class="hero-title" data-aos="fade-up" data-aos-delay="150">Become the Right <span class="text-primary">Mentor</span> for Future Leaders</h1>
                    
                    <div class="mentor-benefits mt-4" data-aos="fade-up" data-aos-delay="200">
                        <div class="benefit-item">
                            <div class="benefit-icon">
                                <i class="fas fa-dollar-sign"></i>
                            </div>
                            <h5>Set Your Rates</h5>
                            <p>Choose your own pricing and earn based on your expertise</p>
                        </div>
                        
                        <div class="benefit-item">
                            <div class="benefit-icon">
                                <i class="fas fa-calendar-alt"></i>
                            </div>
                            <h5>Flexible Schedule</h5>
                            <p>Mentor when it's convenient for you</p>
                        </div>
                        
                        <div class="benefit-item">
                            <div class="benefit-icon">
                                <i class="fas fa-star"></i>
                            </div>
                            <h5>Build Your Brand</h5>
                            <p>Grow your personal brand and reputation</p>
                        </div>
                    </div>
                    
                    <div class="mt-4" data-aos="fade-up" data-aos-delay="250">
                        <a href="<?php echo base_url('register?role=mentor') ?>" class="btn btn-primary btn-lg mentor-cta-btn">Become a Mentor</a>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-6 d-none d-lg-block">
                <div class="floating-mentors-container">
                    <?php 
                    $random_mentors = $mentors;
                    shuffle($random_mentors);
                    $random_mentors = array_slice($random_mentors, 0, 7);
                    
                    $positions = [
                        ['top' => '5%', 'left' => '10%', 'rotation' => '-8deg', 'scale' => '0.85', 'delay' => '0'],
                        ['top' => '15%', 'left' => '55%', 'rotation' => '5deg', 'scale' => '0.9', 'delay' => '100'],
                        ['top' => '40%', 'left' => '20%', 'rotation' => '-3deg', 'scale' => '1', 'delay' => '200'],
                        ['top' => '60%', 'left' => '60%', 'rotation' => '7deg', 'scale' => '0.85', 'delay' => '300'],
                        ['top' => '75%', 'left' => '20%', 'rotation' => '-5deg', 'scale' => '0.8', 'delay' => '400'],
                        ['top' => '25%', 'left' => '75%', 'rotation' => '-6deg', 'scale' => '0.85', 'delay' => '500'],
                        ['top' => '90%', 'left' => '50%', 'rotation' => '4deg', 'scale' => '0.75', 'delay' => '600'],
                    ];
                    
                    foreach($random_mentors as $index => $mentor): 
                    $position = $positions[$index % count($positions)];
                    ?>
                        <div class="floating-mentor" 
                             data-aos="fade-up" 
                             data-aos-delay="<?php echo $position['delay']; ?>" 
                             style="top: <?php echo $position['top']; ?>; 
                                    left: <?php echo $position['left']; ?>; 
                                    transform: rotate(<?php echo $position['rotation']; ?>) scale(<?php echo $position['scale']; ?>);">
                            <a href="<?php echo base_url('mentor/'.$mentor->slug) ?>" class="floating-mentor-card">
                                <div class="floating-mentor-avatar">
                                    <img src="<?php echo base_url($mentor->thumb) ?>" alt="<?php echo html_escape($mentor->name) ?>">
                                </div>
                                <div class="floating-mentor-info">
                                    <h4 class="floating-mentor-name mb-0"><?php echo html_escape($mentor->name) ?></h4>
                                    <small>
                                        <?php
                                            if (!empty($mentor->category)): 
                                                $usrcategory = explode(',', $mentor->category);
                                                $cname = array();
                                                foreach($usrcategory as $uid){
                                                    $cname[] = get_by_id($uid, 'categories')->name;
                                                }
                                                echo implode(' · ', array_slice($cname, 0, 2));
                                                if (count($cname) > 2) echo ' +' . (count($cname) - 2);
                                            endif; 
                                        ?>
                                    </small>
                                </div>
                            </a>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
    
    <div class="hero-bg-shape-1"></div>
    <!-- <div class="hero-bg-shape-2"></div> -->
</section>

<?php if(!empty($mentors)): ?>
<section class="featured-mentors-section py-8 bg-white border-bottom">
    <div class="container">
        <div class="text-center mb-5" data-aos="fade-up">
            <h2>Featured <span class="text-primary">Mentors</span></h2>
            <p class="lead mb-0">Connect with industry experts who can guide your growth journey</p>
        </div>

        <div class="row">
            <?php if(empty($mentors)): ?>
                <?php $this->load->view('include/not_found_msg'); ?>
            <?php else: ?>
                <div class="col-12">
                    <div class="custom-mentor-carousel">
                        <div class="custom-carousel-container">
                            <div class="custom-carousel-track" id="featuredMentorTrack">
                                <?php include APPPATH.'views/include/mentor_card_new.php'; ?> 
                            </div>
                        </div>
                        
                        <div class="custom-carousel-nav">
                            <button class="custom-carousel-prev" id="featuredMentorPrev">
                                <i class="bi bi-chevron-left"></i>
                            </button>
                            <div class="custom-carousel-dots" id="featuredMentorDots"></div>
                            <button class="custom-carousel-next" id="featuredMentorNext">
                                <i class="bi bi-chevron-right"></i>
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="col-12 text-center mt-5">
                    <a href="<?php echo base_url('mentors') ?>" class="btn btn-outline-primary rounded-pill px-4 py-2">View All Mentors <i class="bi bi-arrow-right ml-2"></i></a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<section class="categories-section py-8 bg-light">
    <div class="container">
        <div class="text-center mb-5" data-aos="fade-up">
            <h2>Explore by <span class="text-primary">Category</span></h2>
            <p class="lead mb-0">Find the perfect mentor in your area of interest</p>
        </div>
        <div class="row g-4 justify-content-center">
            <?php if(!empty($categories)): ?>
                <?php foreach($categories as $category): ?>
                    <div class="col-6 col-md-4 col-lg-3 mb-4" data-aos="fade-up" data-aos-delay="<?php echo $loop_count ?? 100 ?>">
                        <a href="<?php echo base_url('mentors?category='.$category->id) ?>" class="category-card-link">
                            <div class="category-card h-100">
                                <div class="category-icon-wrapper">
                                    <i class="<?php echo $category->icon ?? 'fas fa-users' ?> category-icon"></i>
                                </div>
                                <p class="category-name" title="<?php echo html_escape($category->name) ?>"><?php echo html_escape($category->name) ?></p>
                                <p class="category-count badge"><?php echo count_mentor_by_category($category->id) ?> <?php echo trans('mentors') ?></p>
                            </div>
                        </a>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="col-12 text-center">
                    <p>No categories found.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<section class="how-it-works py-8">
    <div class="container">
        <div class="text-center mb-5" data-aos="fade-up">
            <span class="badge btn-primary-linear">Simple Process</span>
            <h2>Find Your Perfect Mentor in <span class="text-primary">3 Simple Steps</span></h2>
            <p class="lead">Getting started with mentorship is easy and straightforward</p>
        </div>
        
        <div class="row g-4">
            <div class="col-md-4" data-aos="fade-up" data-aos-delay="100">
                <div class="process-card">
                    <div class="process-icon-wrapper">
                        <span class="process-number">1</span>
                        <i class="fas fa-search process-icon"></i>
                    </div>
                    <h3 class="process-title">Search</h3>
                    <p class="process-text">Browse through our curated list of experienced mentors in your field. Filter by skills, experience, or price to find the perfect match.</p>
                </div>
            </div>
            
            <div class="col-md-4" data-aos="fade-up" data-aos-delay="200">
                <div class="process-card">
                    <div class="process-icon-wrapper">
                        <span class="process-number">2</span>
                        <i class="fas fa-comments process-icon"></i>
                    </div>
                    <h3 class="process-title">Connect</h3>
                    <p class="process-text">Schedule a consultation session with your chosen mentor. Our platform makes it easy to book and manage your sessions.</p>
                </div>
            </div>
            
            <div class="col-md-4" data-aos="fade-up" data-aos-delay="300">
                <div class="process-card">
                    <div class="process-icon-wrapper">
                        <span class="process-number">3</span>
                        <i class="fas fa-rocket process-icon"></i>
                    </div>
                    <h3 class="process-title">Grow</h3>
                    <p class="process-text">Learn, develop new skills, and achieve your goals with personalized guidance from industry experts who've been there before.</p>
                </div>
            </div>
        </div>
        
        <div class="text-center mt-5" data-aos="fade-up">
            <a href="<?php echo base_url('register') ?>" class="btn btn-primary">Start Your Growth Journey</a>
        </div>
    </div>
</section>

<!-- Testimonials Section -->
<section class="testimonials-section py-8">
    <div class="container">
        <div class="row justify-content-center mb-5">
            <div class="col-lg-6 text-center" data-aos="fade-up">
                <h2 class="section-title">What Our Users Say</h2>
                <p class="section-subtitle">Hear from professionals who have transformed their careers with our mentors</p>
            </div>
        </div>
        
        <?php if (!empty($testimonials)) : ?>
        <div class="testimonial-carousel" data-aos="fade-up" data-aos-delay="100">
            <div class="row">
                <?php foreach ($testimonials as $testimonial) : ?>
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="testimonial-card">
                        <div class="testimonial-content">
                            <div class="testimonial-rating">
                                <?php 
                                $rating = isset($testimonial['rating']) ? (int)$testimonial['rating'] : 5;
                                for ($i = 1; $i <= 5; $i++) {
                                    if ($i <= $rating) {
                                        echo '<i class="fas fa-star"></i>';
                                    } else {
                                        echo '<i class="far fa-star"></i>';
                                    }
                                }
                                ?>
                            </div>
                            <p class="testimonial-text">"<?php echo $testimonial['text'] ?? 'Working with my mentor has been an incredible experience. I\'ve gained new insights and skills that have helped me advance in my career.' ?>"</p>
                        </div>
                        <div class="testimonial-author">
                            <div class="testimonial-author-avatar">
                                <?php if (!empty($testimonial['image'])) : ?>
                                    <img src="<?php echo base_url($testimonial['image']) ?>" alt="<?php echo $testimonial['name'] ?? 'User' ?>">
                                <?php else : ?>
                                    <div class="avatar-placeholder">
                                        <?php 
                                        $name = $testimonial['name'] ?? 'User';
                                        echo strtoupper(substr($name, 0, 1));
                                        ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="testimonial-author-details">
                                <h5 class="testimonial-author-name"><?php echo $testimonial['name'] ?? 'Anonymous User' ?></h5>
                                <p class="testimonial-author-title"><?php echo $testimonial['title'] ?? 'Mentee' ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
            
            <div class="text-center mt-4">
                <button class="btn btn-outline-primary testimonial-prev-btn me-2"><i class="fas fa-arrow-left"></i></button>
                <button class="btn btn-outline-primary testimonial-next-btn"><i class="fas fa-arrow-right"></i></button>
            </div>
        </div>
        <?php else : ?>
        <div class="text-center py-5 text-muted">
            <i class="fas fa-comment-alt fa-3x mb-3"></i>
            <h4>No testimonials available</h4>
            <p>Be the first to share your experience with our mentors!</p>
        </div>
        <?php endif; ?>
    </div>
</section>

<section class="cta-section py-8">
    <div class="container">
        <div class="cta-card" data-aos="fade-up">
            <div class="row align-items-center">
                <div class="col-lg-7">
                    <h2 class="cta-title">Ready to Accelerate Your Career Growth?</h2>
                    <p class="cta-text">Join thousands of professionals who have transformed their careers through expert mentorship. Your next level is waiting.</p>
                    
                    <div class="cta-stats">
                        <div class="cta-stat">
                            <div class="cta-stat-number"><?php echo $count_mentors ?? 0 ?>+</div>
                            <div class="cta-stat-label">Expert Mentors</div>
                        </div>
                        <div class="cta-stat">
                            <div class="cta-stat-number"><?php echo $count_bookings ?? 0 ?>+</div>
                            <div class="cta-stat-label">Sessions Completed</div>
                        </div>
                        <div class="cta-stat">
                            <div class="cta-stat-number"><?php echo $count_countries ?? 0 ?>+</div>
                            <div class="cta-stat-label">Countries</div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-5 text-center text-lg-end">
                    <div class="cta-buttons">
                        <a href="<?php echo base_url('register') ?>" class="btn btn-primary btn-lg">Get Started Now</a>
                        <a href="<?php echo base_url('mentors') ?>" class="btn btn-light btn-lg ms-3">Browse Mentors</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<style>
.icon-circle {
    width: 48px;
    height: 48px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
}

.icon-circle i {
    font-size: 22px;
}

.border-left-lg {
    border-left: none;
}

@media (min-width: 992px) {
    .border-left-lg {
        border-left: 1px solid rgba(0,0,0,0.1);
        padding-left: 3rem;
    }
}

.error-shake {
    animation: shake 0.5s cubic-bezier(.36,.07,.19,.97) both;
    transform: translate3d(0, 0, 0);
}

@keyframes shake {
    10%, 90% {
        transform: translate3d(-1px, 0, 0);
    }
    20%, 80% {
        transform: translate3d(2px, 0, 0);
    }
    30%, 50%, 70% {
        transform: translate3d(-4px, 0, 0);
    }
    40%, 60% {
        transform: translate3d(4px, 0, 0);
    }
}
</style>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const viewToggle = document.getElementById('view-toggle');
    const menteeContent = document.getElementById('mentee-content');
    const mentorContent = document.getElementById('mentor-content');
    const menteeText = document.querySelector('.toggle-mentee');
    const mentorText = document.querySelector('.toggle-mentor');
    
    const searchForm = document.getElementById('hero-search-form');
    const searchInput = searchForm ? searchForm.querySelector('.hero-search-input') : null;
    
    if (searchForm) {
        searchForm.addEventListener('submit', function(e) {
            if (searchInput && searchInput.value.trim() === '') {
                e.preventDefault();
                searchInput.focus();
                searchInput.classList.add('error-shake');
                setTimeout(() => {
                    searchInput.classList.remove('error-shake');
                }, 600);
            }
        });
    }
    
    viewToggle.addEventListener('change', function() {
        if (this.checked) {
            menteeContent.classList.remove('active');
            mentorContent.classList.add('active');
            menteeText.classList.remove('active');
            mentorText.classList.add('active');
        } else {
            mentorContent.classList.remove('active');
            menteeContent.classList.add('active');
            mentorText.classList.remove('active');
            menteeText.classList.add('active');
        }
    });
    
    // Adding hover animation to floating cards
    const floatingMentors = document.querySelectorAll('.floating-mentor');
    floatingMentors.forEach(card => {
        card.addEventListener('mouseenter', function() {
            this.style.zIndex = "10";
        });
        
        card.addEventListener('mouseleave', function() {
            setTimeout(() => {
                this.style.zIndex = "1";
            }, 300);
        });
    });
    
    initFeaturedMentorsCarousel();
});

function initFeaturedMentorsCarousel() {
    const track = document.getElementById('featuredMentorTrack');
    const prevButton = document.getElementById('featuredMentorPrev');
    const nextButton = document.getElementById('featuredMentorNext');
    const dotsContainer = document.getElementById('featuredMentorDots');
    
    if (!track || !prevButton || !nextButton || !dotsContainer) return;
    
    let cards = Array.from(track.children);
    if (!cards.length) return;
    
    const getConfig = () => {
        const width = window.innerWidth;
        if (width < 576) {
            return { slidesToShow: 1, slidesToScroll: 1 };
        } else if (width < 768) {
            return { slidesToShow: 1, slidesToScroll: 1 };
        } else if (width < 992) {
            return { slidesToShow: 2, slidesToScroll: 1 };
        } else if (width < 1200) {
            return { slidesToShow: 3, slidesToScroll: 1 };
        } else {
            return { slidesToShow: 4, slidesToScroll: 1 };
        }
    };
    
    let config = getConfig();
    let currentIndex = 0;
    
    const setCardWidth = () => {
        const config = getConfig();
        const containerWidth = track.parentElement.offsetWidth;
        const cardWidth = containerWidth / config.slidesToShow;
        
        cards.forEach(card => {
            card.style.minWidth = `${cardWidth}px`;
            card.style.maxWidth = `${cardWidth}px`;
        });
        
        track.style.width = `${cardWidth * cards.length}px`;
        
        if (currentIndex > cards.length - config.slidesToShow) {
            currentIndex = Math.max(0, cards.length - config.slidesToShow);
            updateTrackPosition();
        }
    };
    
    const generateDots = () => {
        const config = getConfig();
        dotsContainer.innerHTML = '';
        const totalDots = Math.ceil((cards.length - (config.slidesToShow - 1)) / config.slidesToScroll);
        
        for (let i = 0; i < totalDots; i++) {
            const dot = document.createElement('button');
            dot.classList.add('custom-carousel-dot');
            if (i === 0) dot.classList.add('active');
            dot.setAttribute('data-index', i * config.slidesToScroll);
            dot.addEventListener('click', () => {
                goToSlide(i * config.slidesToScroll);
            });
            dotsContainer.appendChild(dot);
        }
    };
    
    const updateDots = () => {
        const config = getConfig();
        const activeDotIndex = Math.floor(currentIndex / config.slidesToScroll);
        const dots = dotsContainer.querySelectorAll('.custom-carousel-dot');
        
        dots.forEach((dot, index) => {
            if (index === activeDotIndex) {
                dot.classList.add('active');
            } else {
                dot.classList.remove('active');
            }
        });
    };
    
    const updateTrackPosition = () => {
        const config = getConfig();
        const cardWidth = track.parentElement.offsetWidth / config.slidesToShow;
        track.style.transform = `translateX(-${currentIndex * cardWidth}px)`;
        
        prevButton.disabled = currentIndex <= 0;
        nextButton.disabled = currentIndex >= cards.length - config.slidesToShow;
        
        updateDots();
    };
    
    const goToSlide = (index) => {
        const config = getConfig();
        currentIndex = Math.min(Math.max(index, 0), cards.length - config.slidesToShow);
        updateTrackPosition();
    };
    
    const moveToPrev = () => {
        const config = getConfig();
        goToSlide(currentIndex - config.slidesToScroll);
    };
    
    const moveToNext = () => {
        const config = getConfig();
        goToSlide(currentIndex + config.slidesToScroll);
    };
    
    prevButton.addEventListener('click', moveToPrev);
    nextButton.addEventListener('click', moveToNext);
    window.addEventListener('resize', () => {
        config = getConfig();
        setCardWidth();
        generateDots();
        updateTrackPosition();
    });
    
    // Touch events for mobile swipe
    let touchStartX = 0;
    let touchEndX = 0;
    let isDragging = false;
    let startTranslate = 0;
    
    // Touch start
    track.addEventListener('touchstart', (e) => {
        touchStartX = e.touches[0].clientX;
        startTranslate = currentIndex * (track.parentElement.offsetWidth / config.slidesToShow);
        isDragging = true;
        track.style.transition = 'none';
    }, { passive: true });
    
    // Touch move
    track.addEventListener('touchmove', (e) => {
        if (!isDragging) return;
        
        const touchCurrentX = e.touches[0].clientX;
        const diff = touchStartX - touchCurrentX;
        
        // Prevent overscrolling
        const maxTranslate = (cards.length - config.slidesToShow) * (track.parentElement.offsetWidth / config.slidesToShow);
        let newTranslate = startTranslate + diff;
        
        // Add resistance at edges
        if (newTranslate < 0) {
            newTranslate = newTranslate / 3;
        } else if (newTranslate > maxTranslate) {
            newTranslate = maxTranslate + (newTranslate - maxTranslate) / 3;
        }
        
        track.style.transform = `translateX(-${newTranslate}px)`;
    }, { passive: true });
    
    // Touch end
    track.addEventListener('touchend', (e) => {
        if (!isDragging) return;
        isDragging = false;
        track.style.transition = 'transform 0.4s ease-in-out';
        
        touchEndX = e.changedTouches[0].clientX;
        const diff = touchStartX - touchEndX;
        const threshold = track.parentElement.offsetWidth * 0.2; // 20% threshold
        
        if (Math.abs(diff) > threshold) {
            if (diff > 0) {
                moveToNext();
            } else {
                moveToPrev();
            }
        } else {
            updateTrackPosition();
        }
    }, { passive: true });
    
    setCardWidth();
    generateDots();
    updateTrackPosition();
}
</script>