<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<section class="hero-section position-relative overflow-hidden">
    <div class="container position-relative">
        <div class="row align-items-center">
            <div class="col-lg-6 position-relative z-index-1">
                <!-- Hero toggle for Mentee/Mentor views -->
                <div class="toggle-container mb-4">
                    <div class="toggle-wrapper">
                        <input type="checkbox" id="view-toggle" class="toggle-input">
                        <label for="view-toggle" class="toggle-label">
                            <span class="toggle-text toggle-mentee active">Mentee</span>
                            <span class="toggle-handle"></span>
                            <span class="toggle-text toggle-mentor">Mentor</span>
                        </label>
                    </div>
                </div>

                <!-- Mentee Content (Default View) -->
                <div id="mentee-content" class="toggle-content active">
                    <h5 class="hero-subtitle-top" data-aos="fade-up" data-aos-delay="100">Accelerate Your Growth with Seasoned Mentor</h5>
                    <h1 class="hero-title" data-aos="fade-up" data-aos-delay="150">Find the Right <span class="text-primary">Mentor</span> for your Big Ideas</h1>
                    
                    <div class="hero-search-container mt-4" data-aos="fade-up" data-aos-delay="200">
                        <div class="hero-search-wrapper">
                            <div class="hero-search-icon">
                                <i class="fas fa-search"></i>
                            </div>
                            <input type="text" class="hero-search-input" placeholder="Search by skills or expertise">
                            <button class="hero-search-btn">FIND MENTORS</button>
                        </div>
                    </div>
                    
                    <div class="mentor-categories mt-4" data-aos="fade-up" data-aos-delay="250">
                        <?php 
                        $categories_limit = array_slice($categories, 0, 7);
                        foreach($categories_limit as $category): 
                        ?>
                            <a href="<?php echo base_url('mentors?category='.$category->id) ?>" class="mentor-category-pill">
                                <?php echo html_escape($category->name) ?>
                            </a>
                        <?php endforeach; ?>
                    </div>
                </div>

                <!-- Mentor Content (Toggle View) -->
                <div id="mentor-content" class="toggle-content">
                    <h5 class="hero-subtitle-top" data-aos="fade-up" data-aos-delay="100">JBuild Your Legacy While Empowering Future Innovators</h5>
                    <h1 class="hero-title" data-aos="fade-up" data-aos-delay="150">Become the Right <span class="text-primary">Mentor</span> for Future Leaders</h1>
                    
                    <div class="mentor-benefits mt-4" data-aos="fade-up" data-aos-delay="200">
                        <div class="benefit-item">
                            <div class="benefit-icon">
                                <i class="fas fa-dollar-sign"></i>
                            </div>
                            <h5>Set Your Rates</h5>
                            <p>Choose your own pricing and earn based on your expertise</p>
                        </div>
                        
                        <div class="benefit-item">
                            <div class="benefit-icon">
                                <i class="fas fa-calendar-alt"></i>
                            </div>
                            <h5>Flexible Schedule</h5>
                            <p>Mentor when it's convenient for you</p>
                        </div>
                        
                        <div class="benefit-item">
                            <div class="benefit-icon">
                                <i class="fas fa-star"></i>
                            </div>
                            <h5>Build Your Brand</h5>
                            <p>Grow your personal brand and reputation</p>
                        </div>
                    </div>
                    
                    <div class="mt-4" data-aos="fade-up" data-aos-delay="250">
                        <a href="<?php echo base_url('register?role=mentor') ?>" class="btn btn-primary btn-lg mentor-cta-btn">Become a Mentor</a>
                    </div>
                </div>
            </div>
            
            <!-- Floating Mentor Cards -->
            <div class="col-lg-6 d-none d-lg-block">
                <div class="floating-mentors-container">
                    <?php 
                    // Get random mentors
                    $random_mentors = $mentors;
                    shuffle($random_mentors);
                    $random_mentors = array_slice($random_mentors, 0, 7);
                    
                    $positions = [
                        ['top' => '5%', 'left' => '10%', 'rotation' => '-8deg', 'scale' => '0.85', 'delay' => '0'],
                        ['top' => '15%', 'left' => '55%', 'rotation' => '5deg', 'scale' => '0.9', 'delay' => '100'],
                        ['top' => '40%', 'left' => '20%', 'rotation' => '-3deg', 'scale' => '1', 'delay' => '200'],
                        ['top' => '60%', 'left' => '60%', 'rotation' => '7deg', 'scale' => '0.85', 'delay' => '300'],
                        ['top' => '75%', 'left' => '20%', 'rotation' => '-5deg', 'scale' => '0.8', 'delay' => '400'],
                        ['top' => '25%', 'left' => '75%', 'rotation' => '-6deg', 'scale' => '0.85', 'delay' => '500'],
                        ['top' => '90%', 'left' => '50%', 'rotation' => '4deg', 'scale' => '0.75', 'delay' => '600'],
                    ];
                    
                    foreach($random_mentors as $index => $mentor): 
                    $position = $positions[$index % count($positions)];
                    ?>
                        <div class="floating-mentor" 
                             data-aos="fade-up" 
                             data-aos-delay="<?php echo $position['delay']; ?>" 
                             style="top: <?php echo $position['top']; ?>; 
                                    left: <?php echo $position['left']; ?>; 
                                    transform: rotate(<?php echo $position['rotation']; ?>) scale(<?php echo $position['scale']; ?>);">
                            <a href="<?php echo base_url('mentor/'.$mentor->slug) ?>" class="floating-mentor-card">
                                <div class="floating-mentor-avatar">
                                    <img src="<?php echo base_url($mentor->thumb) ?>" alt="<?php echo html_escape($mentor->name) ?>">
                                </div>
                                <div class="floating-mentor-info">
                                    <h4 class="floating-mentor-name mb-0"><?php echo html_escape($mentor->name) ?></h4>
                                    <small>
                                        <?php
                                            if (!empty($mentor->category)): 
                                                $usrcategory = explode(',', $mentor->category);
                                                $cname = array();
                                                foreach($usrcategory as $uid){
                                                    $cname[] = get_by_id($uid, 'categories')->name;
                                                }
                                                echo implode(' · ', array_slice($cname, 0, 2));
                                                if (count($cname) > 2) echo ' +' . (count($cname) - 2);
                                            endif; 
                                        ?>
                                    </small>
                                </div>
                            </a>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Background decorative elements -->
    <div class="hero-bg-shape-1"></div>
    <div class="hero-bg-shape-2"></div>
</section>

<?php if(!empty($mentors)): ?>
<section class="featured-mentors-section py-8 bg-white border-bottom">
    <div class="container">
        <div class="text-center mb-5" data-aos="fade-up">
            <h2>Featured <span class="text-primary">Mentors</span></h2>
            <p class="lead mb-0">Connect with industry experts who can guide your growth journey</p>
        </div>

        <div class="row">
            <?php if(empty($mentors)): ?>
                <?php $this->load->view('include/not_found_msg'); ?>
            <?php else: ?>
                <div class="col-12">
                    <div class="custom-mentor-carousel">
                        <div class="custom-carousel-container">
                            <div class="custom-carousel-track" id="featuredMentorTrack">
                                <?php foreach ($mentors as $mentor): ?>
                                    <div class="mentor-card">
                                        <div class="cards">
                                            <a href="<?php echo base_url('mentor/'. $mentor->slug) ?>">
                                                <?php if (empty($mentor->image)): ?>
                                                    <?php $mentor_img = base_url('assets/images/no-photo-sm.png'); ?>
                                                <?php else: ?>
                                                    <?php $mentor_img = base_url($mentor->image); ?>
                                                <?php endif ?>
                                                <div class="uitem-bg" style="background-image: url(<?php echo $mentor_img; ?>)">
                                                    <?php if (!empty($mentor->respond_time) && $mentor->respond_in == 'hour'): ?>
                                                        <span class="available-badge" data-toggle="tooltip" data-title="<?php echo trans('available-asap') ?>">
                                                            <i class="bi bi-lightning-charge-fill"></i>
                                                        </span>
                                                    <?php endif ?>

                                                    <?php if ($mentor->kyc_verified == 1): ?>
                                                        <span class="verified-badge" data-toggle="tooltip" data-title="<?php echo trans('kyc').' '.trans('verified') ?>">
                                                            <i class="bi bi-shield-check"></i>
                                                        </span>
                                                    <?php endif ?>
                                                </div>
                                            </a>

                                            <div class="card-body">
                                                <div class="d-flex justify-content-between align-items-center mb-2">
                                                    <div class="mentor_title"><?php echo html_escape($mentor->name); ?></div>
                                                    <?php $code = get_by_id($mentor->country, 'country')->code; ?>
                                                    <div>
                                                        <img data-toggle="tooltip" data-placement="top" title="<?php echo get_by_id($mentor->country, 'country')->name; ?>" class="flag-cimg" src="<?php echo base_url('assets/images/flags/'.strtolower($code).'.png') ?>">
                                                    </div>
                                                </div>

                                                <div class="mb-3 fs-13">
                                                    <?php if (!empty($mentor->designation)): ?>
                                                        <span><i class="bi bi-briefcase"></i> <?php echo html_escape($mentor->designation) ?>
                                                    <?php endif ?> 
                                                    <?php if (!empty($mentor->company)): ?>
                                                        <span class="text-muted fw-500"><?php echo trans('at') ?></span> <?php echo html_escape($mentor->company) ?>.</span>
                                                    <?php endif ?>
                                                </div>
                                                
                                                <div class="mb-3 fs-13">
                                                    <i class="bi bi-tag"></i> 
                                                    <?php 
                                                        if (!empty($mentor->category)): 
                                                            $usrcategory = explode(',', $mentor->category);
                                                            $cname = array();
                                                            foreach($usrcategory as $uid){
                                                                $cname[] = get_by_id($uid, 'categories')->name;
                                                            }
                                                            echo implode(' · ', array_slice($cname, 0, 2));
                                                            if (count($cname) > 2) echo ' +' . (count($cname) - 2);
                                                        endif; 
                                                    ?> 
                                                </div>

                                                <div class="d-flex justify-content-between fs-12">
                                                    <div>
                                                        <p class="mb-0 fw-500 text-muted"><?php echo trans('experience') ?></p>
                                                        <p class="mt-0 mb-0 text-dark fs-16">
                                                            <?php if (empty($mentor->experience_year)): ?>
                                                                1 <?php echo trans('years') ?>
                                                            <?php else: ?>
                                                                <?php echo html_escape($mentor->experience_year); ?> <?php echo trans('years') ?>
                                                            <?php endif ?>
                                                        </p>
                                                    </div>
                                                    <?php if($mentor->minprice <= 0 &&  $mentor->maxprice <= 0){} else{ ?>
                                                    <div class="brr-1"></div>
                                                    <div>
                                                        <p class="mb-0 fw-500 text-muted"><?php echo trans('price') ?></p>
                                                        <p class="mt-0 mb-0 text-dark fs-16"><?php echo settings()->currency_symbol.' '.$mentor->minprice.' - '.$mentor->maxprice;?></p>
                                                    </div>
                                                    <?php }?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach ?>
                            </div>
                        </div>
                        
                        <div class="custom-carousel-nav">
                            <button class="custom-carousel-prev" id="featuredMentorPrev">
                                <i class="bi bi-arrow-left"></i>
                            </button>
                            <div class="custom-carousel-dots" id="featuredMentorDots"></div>
                            <button class="custom-carousel-next" id="featuredMentorNext">
                                <i class="bi bi-arrow-right"></i>
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="col-12 text-center mt-5">
                    <a href="<?php echo base_url('mentors') ?>" class="btn btn-outline-primary rounded-pill px-4 py-2">View All Mentors <i class="bi bi-arrow-right ml-2"></i></a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Categories Section -->
<section class="categories-section py-8 bg-light">
    <div class="container">
        <div class="text-center mb-5" data-aos="fade-up">
            <h2>Explore by <span class="text-primary">Category</span></h2>
            <p class="lead mb-0">Find the perfect mentor in your area of interest</p>
        </div>
        <div class="row g-4 justify-content-center">
            <?php if(!empty($categories)): ?>
                <?php foreach($categories as $category): ?>
                    <div class="col-6 col-md-4 col-lg-3 mb-4" data-aos="fade-up" data-aos-delay="<?php echo $loop_count ?? 100 ?>">
                        <a href="<?php echo base_url('mentors?category='.$category->id) ?>" class="category-card-link">
                            <div class="category-card h-100">
                                <div class="category-icon-wrapper">
                                    <i class="<?php echo $category->icon ?? 'fas fa-users' ?> category-icon"></i>
                                </div>
                                <h3 class="category-name"><?php echo $category->name ?></h3>
                                <p class="category-count badge"><?php echo count_mentor_by_category($category->id) ?> <?php echo trans('mentors') ?></p>
                            </div>
                        </a>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="col-12 text-center">
                    <p>No categories found.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<!-- How It Works Section -->
<section class="how-it-works py-8">
    <div class="container">
        <div class="text-center mb-5" data-aos="fade-up">
            <span class="badge btn-primary-linear">Simple Process</span>
            <h2>Find Your Perfect Mentor in <span class="text-primary">3 Simple Steps</span></h2>
            <p class="lead">Getting started with mentorship is easy and straightforward</p>
        </div>
        
        <div class="row g-4">
            <div class="col-md-4" data-aos="fade-up" data-aos-delay="100">
                <div class="process-card">
                    <div class="process-icon-wrapper">
                        <span class="process-number">1</span>
                        <i class="fas fa-search process-icon"></i>
                    </div>
                    <h3 class="process-title">Search</h3>
                    <p class="process-text">Browse through our curated list of experienced mentors in your field. Filter by skills, experience, or price to find the perfect match.</p>
                </div>
            </div>
            
            <div class="col-md-4" data-aos="fade-up" data-aos-delay="200">
                <div class="process-card">
                    <div class="process-icon-wrapper">
                        <span class="process-number">2</span>
                        <i class="fas fa-comments process-icon"></i>
                    </div>
                    <h3 class="process-title">Connect</h3>
                    <p class="process-text">Schedule a consultation session with your chosen mentor. Our platform makes it easy to book and manage your sessions.</p>
                </div>
            </div>
            
            <div class="col-md-4" data-aos="fade-up" data-aos-delay="300">
                <div class="process-card">
                    <div class="process-icon-wrapper">
                        <span class="process-number">3</span>
                        <i class="fas fa-rocket process-icon"></i>
                    </div>
                    <h3 class="process-title">Grow</h3>
                    <p class="process-text">Learn, develop new skills, and achieve your goals with personalized guidance from industry experts who've been there before.</p>
                </div>
            </div>
        </div>
        
        <div class="text-center mt-5" data-aos="fade-up">
            <a href="<?php echo base_url('register') ?>" class="btn btn-primary">Start Your Growth Journey</a>
        </div>
    </div>
</section>

<!-- Testimonials Section -->
<section class="testimonials-section py-8">
    <div class="container">
        <div class="row justify-content-center mb-5">
            <div class="col-lg-6 text-center" data-aos="fade-up">
                <h2 class="section-title">What Our Users Say</h2>
                <p class="section-subtitle">Hear from professionals who have transformed their careers with our mentors</p>
            </div>
        </div>
        
        <?php if (!empty($testimonials)) : ?>
        <div class="testimonial-carousel" data-aos="fade-up" data-aos-delay="100">
            <div class="row">
                <?php foreach ($testimonials as $testimonial) : ?>
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="testimonial-card">
                        <div class="testimonial-content">
                            <div class="testimonial-rating">
                                <?php 
                                $rating = isset($testimonial['rating']) ? (int)$testimonial['rating'] : 5;
                                for ($i = 1; $i <= 5; $i++) {
                                    if ($i <= $rating) {
                                        echo '<i class="fas fa-star"></i>';
                                    } else {
                                        echo '<i class="far fa-star"></i>';
                                    }
                                }
                                ?>
                            </div>
                            <p class="testimonial-text">"<?php echo $testimonial['text'] ?? 'Working with my mentor has been an incredible experience. I\'ve gained new insights and skills that have helped me advance in my career.' ?>"</p>
                        </div>
                        <div class="testimonial-author">
                            <div class="testimonial-author-avatar">
                                <?php if (!empty($testimonial['image'])) : ?>
                                    <img src="<?php echo base_url($testimonial['image']) ?>" alt="<?php echo $testimonial['name'] ?? 'User' ?>">
                                <?php else : ?>
                                    <div class="avatar-placeholder">
                                        <?php 
                                        $name = $testimonial['name'] ?? 'User';
                                        echo strtoupper(substr($name, 0, 1));
                                        ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="testimonial-author-details">
                                <h5 class="testimonial-author-name"><?php echo $testimonial['name'] ?? 'Anonymous User' ?></h5>
                                <p class="testimonial-author-title"><?php echo $testimonial['title'] ?? 'Mentee' ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
            
            <div class="text-center mt-4">
                <button class="btn btn-outline-primary testimonial-prev-btn me-2"><i class="fas fa-arrow-left"></i></button>
                <button class="btn btn-outline-primary testimonial-next-btn"><i class="fas fa-arrow-right"></i></button>
            </div>
        </div>
        <?php else : ?>
        <div class="text-center py-5 text-muted">
            <i class="fas fa-comment-alt fa-3x mb-3"></i>
            <h4>No testimonials available</h4>
            <p>Be the first to share your experience with our mentors!</p>
        </div>
        <?php endif; ?>
    </div>
</section>

<!-- Call to Action Section -->
<section class="cta-section py-8">
    <div class="container">
        <div class="cta-card" data-aos="fade-up">
            <div class="row align-items-center">
                <div class="col-lg-7">
                    <h2 class="cta-title">Ready to Accelerate Your Career Growth?</h2>
                    <p class="cta-text">Join thousands of professionals who have transformed their careers through expert mentorship. Your next level is waiting.</p>
                    
                    <div class="cta-stats">
                        <div class="cta-stat">
                            <div class="cta-stat-number"><?php echo $count_mentors ?? 0 ?>+</div>
                            <div class="cta-stat-label">Expert Mentors</div>
                        </div>
                        <div class="cta-stat">
                            <div class="cta-stat-number"><?php echo $count_bookings ?? 0 ?>+</div>
                            <div class="cta-stat-label">Sessions Completed</div>
                        </div>
                        <div class="cta-stat">
                            <div class="cta-stat-number"><?php echo $count_countries ?? 0 ?>+</div>
                            <div class="cta-stat-label">Countries</div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-5 text-center text-lg-end">
                    <div class="cta-buttons">
                        <a href="<?php echo base_url('register') ?>" class="btn btn-primary btn-lg">Get Started Now</a>
                        <a href="<?php echo base_url('mentors') ?>" class="btn btn-light btn-lg ms-3">Browse Mentors</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="border-bottom border-light b2section mt-0 pb-8 pt-8">
    <div class="container">
        <div class="position-absolute shape grape w-5 d-none d-lg-block" data-aos="fade-in" data-aos-delay="450" style="top: 0%; right: -2%; animation-name: fadeIn; animation-duration: 700ms; animation-timing-function: ease; animation-delay: 1500ms; animation-direction: normal; animation-fill-mode: both; color: rgb(96, 93, 186);" data-cue="fadeIn" data-delay="1500" data-show="true"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 219.5 219.5" data-inject-url="" class="svg-inject icon-svg w-100 h-100" style=""><path class="svg-fill svgc1" d="M219.5 219.5H0c0-58.19 23.14-114.06 64.29-155.21A219.561 219.561 0 01219.5 0v219.5z"></path></svg></div>
        
        <div class="position-absolute shape violet w-10 d-none d-lg-block" data-aos="fade-in" data-aos-delay="550" style="bottom: 25%; right: -1%; animation-name: fadeIn; animation-duration: 700ms; animation-timing-function: ease; animation-delay: 1500ms; animation-direction: normal; animation-fill-mode: both;" data-cue="fadeIn" data-delay="1500" data-show="true"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 457.71 446.45" data-inject-url="https://sandbox.elemisthemes.com/assets/img/svg/scribble.svg" class="svg-inject icon-svg w-100 h-100"><path class="svg-fill svgc2" d="M205.62 442.54c-.51-.41-.99-.84-1.46-1.31-10.4-10.39-3.61-27.12 11.63-52.5 11.72-19.51 28.48-43.74 46.22-69.39 17.53-25.34 35.66-51.54 49.01-73.47 14.73-24.19 18.57-35.01 19.51-39.48-3.86-.28-13.15.3-33.78 6.52-19.71 5.94-43.09 14.92-65.7 23.6-63.8 24.49-85.35 31.41-96.51 19.5-3.21-3.43-7.62-11.04-1.12-23.54 2.49-4.79 6.64-10.51 12.68-17.5 10.4-12.03 25.04-26.34 40.55-41.49 14.02-13.7 28.53-27.87 39.53-40.11 9.93-11.04 14.15-17.43 15.94-20.82-3.43-.75-10.24-1.51-23.25-.92-14.99.68-33.44 2.89-51.28 5.02-46.92 5.61-74.09 8.33-86.81-.99-4.78-3.5-7.67-8.42-8.41-14.24-1.97-15.58 12.45-33.15 29.14-53.5 5.31-6.47 13.31-16.22 17.36-22.68-4.51-.38-12.43-.4-25.97 1.1-16.54 1.82-35.62 5.22-50.95 7.96-12.62 2.25-22.6 4.03-28.48 4.49C6.6 39.3.58 34.17.04 27.28c-.54-6.88 4.6-12.9 11.48-13.44 4.66-.37 14.58-2.13 26.06-4.18C54.56 6.63 75.7 2.86 94 1.07c26.41-2.6 40.16-.54 47.48 7.13 7.01 7.34 6.45 17.66-1.68 30.66-4.72 7.55-11.63 15.98-18.95 24.9-6.18 7.53-12.57 15.31-17.24 22.19-3.35 4.92-4.95 8.13-5.71 10.07 3 .54 9.09 1.08 20.87.43 13.21-.73 29.07-2.63 45.86-4.64 59.99-7.17 94.33-10.22 102.49 10.62 7.4 18.93-16.51 43.51-62.99 88.92-12.69 12.4-24.68 24.11-34.04 34.28-3.17 3.45-5.68 6.34-7.67 8.75 15.88-4.42 41.18-14.13 59.67-21.22 62.4-23.96 101.69-37.87 121.09-29.14 5.38 2.42 9.26 6.47 11.23 11.72 7.48 19.95-16.15 57.31-71.83 137.82-15.49 22.39-30.12 43.55-41.18 61.25-7.13 11.4-11.3 19.11-13.75 24.25 8.97-3.3 25.58-11 55.73-28.8 32.68-19.29 70.61-44.04 101.09-63.94 24.62-16.07 44.07-28.76 54.65-34.68 6.03-3.37 13.64-1.22 17.01 4.81 3.37 6.03 1.22 13.64-4.81 17.01-9.83 5.5-29.92 18.61-53.18 33.79-33.46 21.84-75.1 49.01-110.05 69.21-49.35 28.51-70.85 35.44-82.46 26.07z"></path></svg></div>

        <div class="position-absolute shape fuchsia w-6 d-none d-lg-block" data-aos="fade-in" data-aos-delay="450" style="op: -5%; left: 0%; transform: rotate(70deg); animation-name: fadeIn; animation-duration: 700ms; animation-timing-function: ease; animation-delay: 1500ms; animation-direction: normal; animation-fill-mode: both;" data-cue="fadeIn" data-delay="1500" data-show="true"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 411.42 329.24" data-inject-url="https://sandbox.elemisthemes.com/assets/img/svg/tri.svg" class="svg-inject icon-svg w-100 h-100"><g data-name="Layer 2"><path class="svg-fill svgc3" d="M164.34 21.92L8.72 251.15c-22.54 33.2 1.24 78.09 41.37 78.09h311.24c40.13 0 63.91-44.89 41.37-78.09L247.08 21.92a50 50 0 00-82.74 0z" data-name="Layer 1"></path></g></svg></div>

        <div class="row">
            <div class="col-md-12 home-image-main text-center">
                <div class="tab-card-header">
                    <ul class="nav nav-tabs card-header-tabs d-flex justify-content-center align-items-center" id="myTab" role="tablist" data-aos="fade-up">
                        <li class="nav-item ml-0">
                            <a class="nav-link active bg-transparent rounded-pill px-4" id="one-tab" data-toggle="tab" href="#one" role="tab" aria-controls="One" aria-selected="true"><?php echo trans('mentee') ?></a>
                        </li>
                        <li class="nav-item ml-0">
                            <a class="nav-link bg-transparent rounded-pill px-4" id="two-tab" data-toggle="tab" href="#two" role="tab" aria-controls="Two" aria-selected="false"><?php echo trans('mentor') ?></a>
                        </li>
                    </ul>
                </div>

                <div class="tab-content text-center" id="myTabContent">
                    <div class="tab-pane fade show active row" id="one" role="tabpanel" aria-labelledby="one-tab">
                        <div class="col-md-12 pt-8 pb-5 pl-0">
                            <h1 data-aos="fade-up" data-aos-delay="250" class="display-3 w-lg-60 m-auto mb-3 font-weight-bold custom-font">
                                <?php echo html_escape(settings()->site_title) ?>
                            </h1>
                           
                            <p data-aos="fade-up" data-aos-delay="350" class="w-lg-50 m-auto fs-20 mt-4 mb-4"><?php echo html_escape(settings()->description) ?></p>
                        </div> 

                        <div class="col-lg-10 col-md-10 mb-8 pl-0 m-auto mt-3" data-aos="fade-up" data-aos-delay="550">
                            <div class="home-search style-two position-relative pull-left border-0 shadow rounded-lg">
                                <form action="<?php echo base_url('home/mentors') ?>" class="blur-md" method="get">
                                    <div class="row align-items-center p-2">
                                        <div class="col-md-4">
                                            <div class="input-box border-right">
                                                 <div class="form-group has-search">
                                                    <span class="bi bi-search text-primary form-control-feedback"></span>
                                                    <input type="text" name="mentor_search_name" class="form-control isearch bg-transparent" value="<?php if(isset($_POST['mentor_search_name'])){echo html_escape($_POST['mentor_search_name']);} ?>" placeholder="Search by mentor, language or role">
                                                  </div>
                                            </div>
                                        </div>

                                        <div class="col-md-3">
                                            <div class="border-right">
                                                <div class="input-box">
                                                    <select class="nice_select wide bg-transparent" name="search_category">
                                                        <option value=""><?php echo trans('categories') ?></option>
                                                        <?php foreach ($categories as $category): ?>
                                                            <option value="<?php echo html_escape($category->id) ?>" <?php if(isset($_POST['search_category']) && $_POST['search_category'] == $category->id){echo 'selected';} ?>><?php echo html_escape($category->name) ?></option>
                                                        <?php endforeach ?>
                                                        
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-3">
                                            <div class="input-box">
                                                <select class="nice_select wide bg-transparent" name="mentor_search_country">
                                                    <option value=""><?php echo trans('country') ?></option>
                                                    <?php foreach ($countries as $country): ?>
                                                        <option value="<?php echo html_escape($country->id) ?>" <?php if(isset($_POST['mentor_search_country']) && $_POST['mentor_search_country'] == $country->id){echo 'selected';} ?>><?php echo html_escape($country->name) ?></option>
                                                    <?php endforeach ?>
                                                </select>
                                            </div>
                                        </div>
                                        <input type="hidden" name="<?php echo html_escape($this->security->get_csrf_token_name());?>" value="<?php echo html_escape($this->security->get_csrf_hash());?>">
                                        
                                        <div class="col-md-2 sm-mb-10 sm-mt-10">
                                            <button type="submit" class="btn-grad btn btn-block-xs-only btn-md fs-14 m-auto grd rounded-pill"><?php echo trans('search') ?></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane fade row" id="two" role="tabpanel" aria-labelledby="two-tab">
                         <div class="col-md-12 pt-8 pl-0 text-center">
                            <h1 class="display-3 w-lg-60 m-auto mb-3 font-weight-bold custom-font">
                                <?php echo html_escape(settings()->site_title_mentor) ?>
                            </h1>
                           
                            <p class="w-lg-50 m-auto fs-20 mt-3 mb-5"><?php echo trans('build-confidence-as-a-leader') ?></p>
                         
                            <div class="lift-sm mb-2 mt-3">
                                <a href="<?php echo base_url('register?trial=start') ?>" class="btn btn-lg btn-outline-secondary mt-4 fs-14 rounded-pill"><?php echo trans('became-a-member') ?> <i class="pl-1 pt-1 bi bi-arrow-right"></i></a>
                            </div>
                        </div>     
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="py-5 bg-primary-soft">
    <div class="container">
        <div class="row justify-content-center text-center">
            <div class="col-md-4" data-aos="zoom-in-up" data-aos-delay="150">
                <div class="py-4 px-4 rounded-lg shadow-sm bg-white m-2">
                    <p class="text-muted mb-1">Available Mentors</p>
                    <h1 class="display-3 font-weight-bold text-primary mb-0"><?php echo shortend_number($count_mentors); ?></h1>
                </div>
            </div>
            
            <div class="col-md-4" data-aos="zoom-in-up" data-aos-delay="250">
                <div class="py-4 px-4 rounded-lg shadow-sm bg-white m-2">
                    <p class="text-muted mb-1">Countries Represented</p>
                    <h1 class="display-3 font-weight-bold text-primary mb-0"><?php echo shortend_number($count_countries); ?></h1>
                    </div>
            </div>

            <div class="col-md-4" data-aos="zoom-in-up" data-aos-delay="350">
                <div class="py-4 px-4 rounded-lg shadow-sm bg-white m-2">
                    <p class="text-muted mb-1">Connections Made</p>
                    <h1 class="display-3 font-weight-bold text-primary mb-0"><?php echo shortend_number($count_bookings); ?></h1>
                </div>
            </div>
        </div>
    </div>
</section>

<?php if (!empty($brands)): ?>
    <section class="bg-grays py-3 border-bottom zi-1">
        <div class="container">
            <div class="brand-carousel-5 owl-carousel owl-theme">
                <?php foreach ($brands as $brand): ?>
                   <div class="item">
                        <a href="<?php echo prep_url($brand->link) ?>">
                            <div class="px-0 px-sm-2 hover-opacity brand_img" style="background-image:url(<?php echo base_url($brand->logo) ?>)"></div>
                        </a>
                    </div>
                <?php endforeach ?>
            </div>
        </div>
    </section>
<?php endif ?>



<?php if (settings()->enable_workflow == 1): ?>
    <section class="zindex-low">
        <div class="container z0">
            <div class="w-md-80 w-lg-50 text-center mx-auto mb-8 mb-lg-10" data-aos="fade-up">
                <span class="badge badge-secondary-soft badge-square mb-3"><?php echo trans('workflow') ?></span>
                <h1 class="text-dark font-weight-bold mx-auto mb-1"><?php echo trans('workflow-title') ?></h2>
            </div>

            <div class="row">
                <?php $w=1; foreach ($workflows as $workflow): ?>
                    <div class="col-md-4 mb-7 mb-md-0" data-aos="zoom-in-up" data-aos-delay="150">
                        <div class="text-center m-2 py-6 px-4 <?php if($w==2){echo "shadow-workflow";} ?>">
                            <div class="mb-5 workflow-img"><img class="display-5" src="<?php echo base_url($workflow->image) ?>" alt="Image"></div>

                            <h5 class="mb-2 mx-auto text-dark"><?php echo html_escape($workflow->title) ?></h5>
                            <p class="text-muted"><?php echo html_escape($workflow->details) ?></p>
                        </div>
                    </div>
                <?php $w++; endforeach ?>
            </div>
        </div>
    </section>
<?php endif; ?>




<!-- features -->
    <?php if (!empty($features)): ?>
        <section class="pt-6 pt-md-5 pt-xl-0 mt-8">

            <div class="container mt-5">
                <div class="text-center mx-auto mb-8">
                    <div class="text-center mx-md-auto mb-5 mb-md-7 mb-lg-9">
                        <div class="badge badge-square badge-secondary-soft mb-3">
                            <span><?php echo trans('features') ?></span>
                        </div>
                        <h1 class="w-70 mx-auto"><?php echo trans('learn-that-new-skill-launch-that-project') ?></h1>
                    </div>
                </div>


                <?php $i=1; foreach ($features as $feature): ?>
                    <div class="row align-items-center justify-content-center mt-6 mb-6" data-aos="fade-<?php if ($i % 2 == 0){echo 'left';}else{echo 'right';} ?>">
                        <?php if ($i % 2 == 0): ?>
                            <div class="col-10 col-sm-9 col-md-6 col-lg-7 text-center pr-md-5 pr-lg-10 mb-5 mb-md-0">
                                <img src="<?php echo base_url($feature->image) ?>" class="screen-one w-90" alt="Feature Image">
                            </div>

                            <div class="col-md-6 col-lg-5">
                                <h4 class="h1 mb-4 custom-font"><?php echo html_escape($feature->name); ?></h4>
                                <p class="lead text-muted mb-6"><?php echo html_escape($feature->details); ?></p>
                            </div>
                        <?php else: ?>
                            <div class="col-md-6 col-lg-5 order-2 order-md-1">
                                <h4 class="h1 mb-4 custom-font"><?php echo html_escape($feature->name); ?></h4>
                                <p class="lead text-muted mb-6"><?php echo html_escape($feature->details); ?></p>
                            </div>

                            <div class="col-10 col-sm-9 col-md-6 col-lg-7 text-center mb-5 mb-md-0 pl-md-5 pl-lg-10 order-1 order-md-2">
                                <img src="<?php echo base_url($feature->image) ?>" class="screen-one w-90" alt="Feature Image">
                            </div>
                        <?php endif ?>
                    </div>
                <?php $i++; endforeach; ?>
            </div>
        </section>
    <?php endif; ?>
    <!-- features -->


<?php if (!empty($features)): ?>
    <section class="bg-white d-none">
        <div class="container">
            <div class="text-center mx-auto mb-8">
                <div class="text-center mx-md-auto mb-5 mb-md-7 mb-lg-9">
                    <div class="badge badge-square badge-secondary-soft mb-3">
                        <span><?php echo trans('features') ?></span>
                    </div>
                    <h1 class="w-70 mx-auto"><?php echo trans('learn-that-new-skill-launch-that-project') ?></h1>
                </div>
            </div>

            <div class="row justify-content-center">
                <?php if(empty($features)): ?>
                    <?php $this->load->view('include/not_found_msg'); ?>
                <?php else: ?>
                    <?php $f=1; foreach ($features as $feature): ?>
                        <div class="col-12 col-md-4 col-lg-4 mb-0 p-0" data-aos="zoom-in-up" data-aos-delay="<?php echo html_escape($f * 100) ?>">
                            <a href="javascript:;">
                                <div class="template-box feature brd-0 lift-sms text-left asminh shadow-sm rounded-1">
                                    <div class="circle-icon ftur bg-white mb-1">
                                        <img src="<?php echo base_url($feature->image) ?>" class="screen-one w-80 p-2" alt="Feature Image">
                                    </div>
                                    <p class="template-box-text ftur text-dark fs-16 mb-2"><?php echo html_escape($feature->name); ?></p>
                                    <p class="template-box-titles fw-500 fs-14 text-muted"><?php echo html_escape($feature->details) ?></p>
                                </div>
                            </a>
                        </div>
                    <?php $f++; endforeach; ?>
                <?php endif; ?>
            </div>

        </div>
    </section>
<?php endif; ?>




<section class="resultbg">
    <div class="container z0">
        <div class="w-md-80 w-lg-80 text-center mx-auto mb-5 mb-lg-10" data-aos="fade-up">
            <h1 class="text-dark display-5 font-weight-bold mx-auto mb-1">A Platform Engineered for Success</h2>
        </div>

        <div class="row">
            <div class="col-md-4" data-aos="zoom-in-up" data-aos-delay="150">
                <div class="text-center m-2 py-6 px-4 round-2 resultitem">
                    <p class="text-muted">Empowered by</p>
                    <h1 class="mb-2 display-2 mx-auto text-dblue"><?php echo shortend_number($count_mentors); ?></h1>
                    <p class="mb-2 fs-20 mx-auto text-dark">Expert Mentors</p>
                </div>
            </div>

            <div class="col-md-4" data-aos="zoom-in-up" data-aos-delay="150">
                <div class="text-center m-2 py-6 px-4 round-2 resultitem">
                    <p class="text-muted">Global community from</p>
                    <h1 class="mb-2 display-2 mx-auto text-dblue"><?php echo shortend_number($count_countries); ?></h1>
                    <p class="mb-2 fs-20 mx-auto text-dark">Countries</p>
                </div>
            </div>

            <div class="col-md-4" data-aos="zoom-in-up" data-aos-delay="150">
                <div class="text-center m-2 py-6 px-4 round-2 resultitem">
                    <p class="text-muted">We have built over</p>
                    <h1 class="mb-2 display-2 mx-auto text-dblue"><?php echo shortend_number($count_bookings); ?></h1>
                    <p class="mb-2 fs-20 mx-auto text-dark">Connections</p>
                </div>
            </div>
        </div>
    </div>
</section>






    
<?php if (settings()->enable_blog == 1 && !empty($posts)): ?>
    <section class="bg-lights pt-6">
        <div class="container">
            <div class="w-md-80 w-lg-50 text-center mx-auto mb-8 mb-lg-10" data-aos="fade-up">
                <span class="badge badge-primary-soft badge-square mb-3"><?php echo trans('blogs') ?></span>
                <h1 class="text-dark font-weight-bold mx-auto mb-1"><?php echo trans('learn-more-empower-yourself') ?></h2>
            </div>

            <div class="row">
                <?php $b=1; foreach ($posts as $post): ?>
                    <?php include'include/blog_post_item.php'; ?>
                <?php $b++; endforeach ?>
            </div>
        </div>
    </section>
<?php endif ?>




<?php if (!empty($testimonials)): ?>
<!-- Testimonials Section - Updated with modern card design -->
<section class="py-8 bg-primary-soft">
    <div class="container">
        <div class="row mb-5">
            <div class="col-12 text-center">
                <span class="badge badge-primary-soft badge-pill px-3 py-2 mb-3"><?php echo trans('testimonia') ?></span>
                <h2 class="display-4 font-weight-bold"><?php echo trans('testimonial-title') ?></h2>
                <p class="lead text-muted w-lg-60 mx-auto mt-3">See what our mentees have to say about their transformative experiences</p>
            </div>
        </div>

        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="testimonial-carousel-2 owl-carousel owl-theme">
                    <?php foreach ($testimonials as $testimonial): ?>
                        <div class="p-2">
                            <div class="card shadow-sm border-0 rounded-lg p-4 h-100 position-relative">
                                <!-- Quote icon -->
                                <div class="quote-icon position-absolute" style="top: 20px; right: 20px; opacity: 0.1; z-index: 0;">
                                    <i class="bi bi-quote fs-40 text-primary"></i>
                                            </div>
                                
                                <div class="d-flex align-items-center mb-4 position-relative" style="z-index: 1;">
                                    <div class="avatar-sm mr-3" style="background-image: url(<?php echo base_url($testimonial->image) ?>); width: 60px; height: 60px; background-size: cover; background-position: center; border-radius: 50%;"></div>
                                    <div>
                                        <h5 class="mb-1 font-weight-bold"><?php echo html_escape($testimonial->name) ?></h5>
                                        <p class="mb-0 text-muted"><?php echo html_escape($testimonial->designation) ?></p>
                                    </div>
                                </div>
                                
                                <div class="testimonial-rating mb-3 position-relative" style="z-index: 1;">
                                    <i class="bi bi-star-fill text-warning"></i>
                                    <i class="bi bi-star-fill text-warning"></i>
                                    <i class="bi bi-star-fill text-warning"></i>
                                    <i class="bi bi-star-fill text-warning"></i>
                                    <i class="bi bi-star-fill text-warning"></i>
                                </div>
                                
                                <div class="testimonial-content position-relative" style="z-index: 1;">
                                    <p class="text-muted mb-0 font-italic">"<?php echo character_limiter($testimonial->feedback, 250) ?>"</p>
                                </div>
                            </div>
                        </div>
                    <?php endforeach ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php endif ?>

<section class="py-8 bg-light">
    <div class="container">
        <div class="row mb-5">
            <div class="col-12 text-center">
                <span class="badge badge-primary-soft badge-pill px-3 py-2 mb-3"><?php echo trans('why-choose-us') ?></span>
                <h2 class="display-4 font-weight-bold">Unlock Your Potential</h2>
                <p class="lead text-muted w-lg-60 mx-auto mt-3">We're committed to helping you achieve your goals through expert guidance and personalized support</p>
            </div>
        </div>

        <div class="row mb-5">
            <div class="col-lg-6 d-flex align-items-center mb-5 mb-lg-0">
                <div class="pr-lg-5">
                    <h3 class="h2 mb-4">For Mentees</h3>
                    <div class="mb-4">
                        <div class="d-flex mb-3">
                            <div class="icon-circle bg-primary-soft mr-3 flex-shrink-0">
                                <i class="bi bi-lightbulb text-primary"></i>
                            </div>
                            <div>
                                <h5 class="mb-1">Innovative Solutions</h5>
                                <p class="text-muted mb-0">Our mentors are industry experts with a wealth of experience and a track record of success. They bring innovative solutions tailored to your unique challenges and goals.</p>
                            </div>
                        </div>
                        
                        <div class="d-flex mb-3">
                            <div class="icon-circle bg-primary-soft mr-3 flex-shrink-0">
                                <i class="bi bi-person-check text-primary"></i>
                            </div>
                            <div>
                                <h5 class="mb-1">Personalized Approach</h5>
                                <p class="text-muted mb-0">We understand that each journey is unique. That's why our 1:1 mentorship sessions are customized to fit your specific needs, providing you with the tools and strategies necessary to achieve your aspirations.</p>
                            </div>
                        </div>
                        
                        <div class="d-flex">
                            <div class="icon-circle bg-primary-soft mr-3 flex-shrink-0">
                                <i class="bi bi-graph-up-arrow text-primary"></i>
                            </div>
                            <div>
                                <h5 class="mb-1">Transformative Impact</h5>
                                <p class="text-muted mb-0">With our mentors, you'll gain insights that can transform your ideas into actionable plans, driving real progress and measurable success.</p>
                            </div>
                        </div>
                    </div>
                    
                    <a href="<?php echo base_url('register?trial=start') ?>" class="btn btn-primary rounded-pill px-4 py-2">Find a Mentor <i class="bi bi-arrow-right ml-2"></i></a>
                </div>
            </div>
            
            <div class="col-lg-6 d-flex align-items-center">
                <div class="pl-lg-5 border-left-lg">
                    <h3 class="h2 mb-4">For Mentors</h3>
                    <div class="mb-4">
                        <div class="d-flex mb-3">
                            <div class="icon-circle bg-success-soft mr-3 flex-shrink-0">
                                <i class="bi bi-trophy text-success"></i>
                            </div>
                            <div>
                                <h5 class="mb-1">Elevate Your Impact</h5>
                                <p class="text-muted mb-0">We connect you with passionate innovators who are eager to learn from your expertise. Your mentorship can spark transformative change and drive meaningful progress.</p>
                            </div>
                        </div>
                        
                        <div class="d-flex mb-3">
                            <div class="icon-circle bg-success-soft mr-3 flex-shrink-0">
                                <i class="bi bi-calendar-check text-success"></i>
                            </div>
                            <div>
                                <h5 class="mb-1">Flexible Engagement</h5>
                                <p class="text-muted mb-0">Whether you prefer short-term consultations or long-term mentoring relationships, we offer the flexibility to choose engagements that fit your schedule and preferences.</p>
                            </div>
                        </div>
                        
                        <div class="d-flex">
                            <div class="icon-circle bg-success-soft mr-3 flex-shrink-0">
                                <i class="bi bi-cash-stack text-success"></i>
                            </div>
                            <div>
                                <h5 class="mb-1">Personal Fulfillment</h5>
                                <p class="text-muted mb-0">Helping others succeed is personally rewarding and can also provide a steady income stream. You gain fulfillment from seeing your mentees thrive while generating reliable income.</p>
                            </div>
                        </div>
                    </div>
                    
                    <a href="<?php echo base_url('register?trial=start') ?>" class="btn btn-success rounded-pill px-4 py-2">Become a Mentor <i class="bi bi-arrow-right ml-2"></i></a>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
.icon-circle {
    width: 48px;
    height: 48px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
}

.icon-circle i {
    font-size: 22px;
}

.border-left-lg {
    border-left: none;
}

@media (min-width: 992px) {
    .border-left-lg {
        border-left: 1px solid rgba(0,0,0,0.1);
        padding-left: 3rem;
    }
}
</style>

<!-- Categories Section - Updated with modern design -->
<section class="py-8 bg-white border-top border-bottom">
    <div class="container">
        <div class="row mb-5">
            <div class="col-12 text-center">
                <span class="badge badge-primary-soft badge-pill px-3 py-2 mb-3"><?php echo trans('categories') ?></span>
                <h2 class="display-4 font-weight-bold"><?php echo trans('browse-mentors-by-categories') ?></h2>
                <p class="lead text-muted w-lg-60 mx-auto mt-3">Find mentors specialized in your area of interest</p>
            </div>
        </div>

        <div class="row">
            <?php if(empty($categories)): ?>
                <?php $this->load->view('include/not_found_msg'); ?>
            <?php else: ?>
                <?php $c=1; foreach ($categories as $category): ?>
                    <div class="col-md-3 mb-4" data-aos="fade-up" data-aos-delay="<?php echo $c * 50 ?>">
                        <a href="<?php echo base_url('mentors?categories='.html_escape($category->slug)); ?>" class="text-decoration-none">
                            <div class="card shadow-sm border-0 rounded-lg text-center h-100 position-relative overflow-hidden hover-lift">
                                <!-- Background color overlay with slight gradient -->
                                <div class="card-img-overlay-bg bg-light" style="opacity: 0.7;"></div>
                                
                                <div class="card-body p-4 position-relative">
                                    <div class="icon-circle bg-primary-soft mx-auto mb-4">
                                        <i class="<?php echo html_escape($category->icon) ?> text-primary"></i>
                                    </div>
                                    
                                    <h4 class="h5 mb-2 text-dark font-weight-bold"><?php echo html_escape($category->name) ?></h4>
                                    
                                    <div class="badge bg-primary-soft text-primary py-1 px-2 rounded">
                                        <?php echo count_mentor_by_category($category->id) ?> <?php echo trans('mentors') ?>
        </div>
        </div>
         
                                <div class="card-footer bg-transparent border-0 pb-4">
                                    <span class="btn btn-sm btn-outline-primary rounded-pill">Explore <i class="bi bi-arrow-right ml-1"></i></span>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php $c++; endforeach ?>
            <?php endif; ?>
        </div>
    </div>
</section>


<script>
document.addEventListener('DOMContentLoaded', function() {
    const viewToggle = document.getElementById('view-toggle');
    const menteeContent = document.getElementById('mentee-content');
    const mentorContent = document.getElementById('mentor-content');
    const menteeText = document.querySelector('.toggle-mentee');
    const mentorText = document.querySelector('.toggle-mentor');
    
    viewToggle.addEventListener('change', function() {
        if (this.checked) {
            menteeContent.classList.remove('active');
            mentorContent.classList.add('active');
            menteeText.classList.remove('active');
            mentorText.classList.add('active');
        } else {
            mentorContent.classList.remove('active');
            menteeContent.classList.add('active');
            mentorText.classList.remove('active');
            menteeText.classList.add('active');
        }
    });
    
    // Adding hover animation to floating cards
    const floatingMentors = document.querySelectorAll('.floating-mentor');
    floatingMentors.forEach(card => {
        card.addEventListener('mouseenter', function() {
            this.style.zIndex = "10";
        });
        
        card.addEventListener('mouseleave', function() {
            setTimeout(() => {
                this.style.zIndex = "1";
            }, 300);
        });
    });
});
</script>





    
