<div class="content-wrapper">
    <?php include "include/breadcrumb.php"; ?>

    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title pt-2">Microsoft Teams Connection Status</h3>
                            <div class="card-tools pull-right">
                                <a href="<?php echo base_url('admin/settings') ?>" class="btn btn-secondary btn-sm ml-2"><i class="fas fa-arrow-left"></i> Back to Settings</a>
                                <?php if ($status == 'connected' || $status == 'token_error'): ?>
                                <a href="<?php echo base_url('admin/teams/reset_connection') ?>" class="btn btn-danger btn-sm ml-2" onclick="return confirm('Are you sure you want to reset the connection? Only do this if you are experiencing persistent authentication issues.')"><i class="fas fa-power-off"></i> Reset Connection</a>
                                <?php endif; ?>
                                <a href="<?php echo base_url('admin/teams/teams_auth') ?>" class="btn btn-primary btn-sm ml-2"><i class="fas fa-plug"></i> Connect with Microsoft</a>
                            </div>
                        </div>

                        <div class="card-body">
                            <?php if ($this->session->flashdata('success')): ?>
                                <div class="alert bg-success-soft brd-2" role="alert"><?php echo $this->session->flashdata('success') ?></div>
                            <?php endif; ?>
                            <?php if ($this->session->flashdata('error')): ?>
                                <div class="alert bg-danger-soft brd-2" role="alert"><?php echo $this->session->flashdata('error') ?></div>
                            <?php endif; ?>

                            <div class="mb-4">
                                <div class="d-flex align-items-center mb-3">
                                    <?php if ($status == 'connected'): ?>
                                        <div class="badge badge-success mr-3 p-2"><i class="fas fa-check-circle"></i> Connected</div>
                                    <?php elseif ($status == 'not_configured'): ?>
                                        <div class="badge badge-danger mr-3 p-2"><i class="fas fa-times-circle"></i> Not Configured</div>
                                    <?php elseif ($status == 'not_authenticated'): ?>
                                        <div class="badge badge-warning mr-3 p-2"><i class="fas fa-exclamation-circle"></i> Not Authenticated</div>
                                    <?php elseif ($status == 'token_error'): ?>
                                        <div class="badge badge-warning mr-3 p-2"><i class="fas fa-exclamation-triangle"></i> Token Error</div>
                                    <?php else: ?>
                                        <div class="badge badge-danger mr-3 p-2"><i class="fas fa-times-circle"></i> Error</div>
                                    <?php endif; ?>
                                    <h4 class="mb-0"><?php echo $message ?></h4>
                                </div>
                                
                                <?php if (!empty($details)): ?>
                                <div class="mt-4">
                                    <h5>Connection Details</h5>
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <tbody>
                                                <?php foreach ($details as $key => $value): ?>
                                                <tr>
                                                    <th width="200"><?php echo ucfirst(str_replace('_', ' ', $key)) ?></th>
                                                    <td><?php echo $value ?></td>
                                                </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>

                            <div class="mt-4">
                                <h5>Troubleshooting Steps</h5>
                                <div class="accordion" id="troubleshootingAccordion">
                                    <div class="card">
                                        <div class="card-header" id="headingOne">
                                            <h2 class="mb-0">
                                                <button class="btn btn-link btn-block text-left" type="button" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                                    Configuration Issues
                                                </button>
                                            </h2>
                                        </div>

                                        <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#troubleshootingAccordion">
                                            <div class="card-body">
                                                <ol>
                                                    <li>Go to <a href="<?php echo base_url('admin/settings') ?>">Settings</a> and check your Teams API configuration.</li>
                                                    <li>Ensure you've entered the correct Client ID and Client Secret from your Microsoft Azure Portal.</li>
                                                    <li>Make sure the redirect URI in your Azure Portal matches <code><?php echo base_url('admin/teams/teams_callback') ?></code>.</li>
                                                    <li>Verify that your application has the required permissions: <code>Calendars.ReadWrite</code>, <code>OnlineMeetings.ReadWrite</code>, <code>User.Read</code>, <code>User.ReadBasic.All</code> and <code>Presence.Read</code>.</li>
                                                </ol>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card">
                                        <div class="card-header" id="headingTwo">
                                            <h2 class="mb-0">
                                                <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                                    Authentication Issues
                                                </button>
                                            </h2>
                                        </div>
                                        <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#troubleshootingAccordion">
                                            <div class="card-body">
                                                <ol>
                                                    <li>If your token has expired, click "Connect with Microsoft" to reauthenticate.</li>
                                                    <li>If you're getting authentication errors, try resetting the connection and reconnecting.</li>
                                                    <li>Make sure you're logging in with the correct Microsoft account that has access to Teams.</li>
                                                    <li>Check if your Microsoft account requires Multi-Factor Authentication (MFA), which might cause issues.</li>
                                                </ol>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> 