<div class="content-wrapper">
    <?php include "include/breadcrumb.php"; ?>

    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="card list_area">
                        <div class="card-header">
                            <h3 class="card-title pt-2">Microsoft Teams Recordings</h3>
                            <div class="card-tools pull-right">
                                <a href="<?php echo base_url('admin/teams') ?>" class="btn btn-secondary btn-sm ml-2"><i class="fas fa-arrow-left"></i> Back to Meetings</a>
                            </div>
                        </div>

                        <div class="card-body table-responsive p-0">
                            <?php if (isset($success) && $success): ?>
                                <div class="alert bg-success-soft brd-2" role="alert"><?php echo $success ?></div>
                            <?php endif; ?>
                            <?php if (isset($error) && $error): ?>
                                <div class="alert bg-danger-soft brd-2" role="alert"><?php echo $error ?></div>
                            <?php endif; ?>

                            <?php if (empty($recordings)): ?>
                                <div class="p-4 text-center">
                                    <div class="mb-3"><i class="fas fa-video fa-3x text-muted"></i></div>
                                    <p class="lead">No recordings found</p>
                                    <p class="text-muted">Recordings of your Teams meetings will appear here once saved</p>
                                </div>
                            <?php else: ?>
                                <table class="table table-hover m-0">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Meeting Title</th>
                                            <th>File Name</th>
                                            <th>Size</th>
                                            <th>Date</th>
                                            <?php if (is_admin()): ?>
                                            <th>User</th>
                                            <?php endif; ?>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $i = 1; foreach ($recordings as $recording): ?>
                                            <tr id="row_<?php echo html_escape($recording->id) ?>">
                                                <th scope="row"><?php echo html_escape($i) ?></th>
                                                <td><?php echo html_escape($recording->meeting_title ?? 'Untitled Meeting') ?></td>
                                                <td><?php echo html_escape($recording->original_name) ?></td>
                                                <td><?php echo byte_format($recording->file_size) ?></td>
                                                <td><?php echo date('M d, Y h:i A', strtotime($recording->created_at)) ?></td>
                                                <?php if (is_admin()): ?>
                                                <td>
                                                    <?php 
                                                    $user = $this->admin_model->get_by_id($recording->user_id, 'users');
                                                    echo $user ? html_escape($user->name) : 'Unknown';
                                                    ?>
                                                </td>
                                                <?php endif; ?>
                                                <td class="actions" width="12%">
                                                    <div class="btn-group">
                                                        <button type="button" class="btn btn-tool" data-toggle="dropdown" aria-expanded="false">
                                                            <i class="fas fa-ellipsis-h"></i>
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right" role="menu">
                                                            <a href="<?php echo base_url($recording->file_path) ?>" target="_blank" class="dropdown-item"><i class="fas fa-play mr-1"></i> Play/Download</a>
                                                            <a href="<?php echo base_url('admin/teams/delete_recording/'.html_escape($recording->id)) ?>" class="dropdown-item delete_item" data-id="<?php echo html_escape($recording->id); ?>"><i class="lni lni-trash-can mr-1"></i> Delete</a>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php $i++; endforeach; ?>
                                    </tbody>
                                </table>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if (!function_exists('byte_format')): ?>
<script>
function byte_format(bytes) {
    if (bytes >= 1073741824) {
        return (bytes / 1073741824).toFixed(2) + ' GB';
    } else if (bytes >= 1048576) {
        return (bytes / 1048576).toFixed(2) + ' MB';
    } else if (bytes >= 1024) {
        return (bytes / 1024).toFixed(2) + ' KB';
    } else if (bytes > 1) {
        return bytes + ' bytes';
    } else if (bytes == 1) {
        return bytes + ' byte';
    } else {
        return '0 bytes';
    }
}

$(document).ready(function() {
    $('.table .file-size').each(function() {
        var bytes = $(this).data('bytes');
        $(this).text(byte_format(bytes));
    });
});
</script>
<?php endif; ?> 