<div class="content-wrapper">
  <!-- Main content -->
  <section class="content container-fluid pt-4">
    <div class="card list_area">
      <div class="card-header with-border pl-2">
        <h3 class="card-title p-0"><?php echo trans('transactions') ?> </h3>
      </div>

      <div class="nav-tabs-wrapper mb-3">
        <ul class="nav nav-pills nav-tabs-custom">
          <li class="nav-item ml-auto">
            <?php if(!is_mentee()): ?>
                <div class="export-group">
                  <a href="<?php echo base_url('admin/payment/export_transactions/csv') ?>" class="export-btn csv-btn">
                    <i class="fas fa-file-csv"></i>
                    <span>Export CSV</span>
                  </a>
                  <a href="<?php echo base_url('admin/payment/export_transactions/excel') ?>" class="export-btn excel-btn">
                    <i class="fas fa-file-excel"></i>
                    <span>Export Excel</span>
                  </a>
                </div>
            <?php endif; ?>
          </li>
        </ul>
      </div>
    
      <div class="col-md-12">
        <?php if(!empty($payments)): ?> 
          <div class="card-body table-responsive p-0">
              <table class="table table-hover <?php if(count($payments) > 10){echo "datatable";} ?> cushover">
                  <thead>
                      <tr>
                          <th>#</th>
                          <th><?php echo trans('date') ?></th>
                          <th><?php echo trans('session') ?></th>
                          <th><?php echo trans('mentor') ?></th>
                          <th><?php echo trans('mentee') ?></th>
                          <th><?php echo trans('commision') ?></th>
                          <th><?php echo trans('amount') ?></th>
                          <th><?php echo trans('status') ?></th>
                          <th><?php echo trans('payment') ?></th>
                          <?php if(is_admin()): ?>
                            <th><?php echo trans('action') ?></th>
                          <?php endif; ?>
                      </tr>
                  </thead>
                  <tbody>
                    <?php $i=1; foreach ($payments as $payment): ?>

                      <?php if ($payment->amount != '0.00'): ?>
                        <tr id="row_<?php echo html_escape($payment->id); ?>">
                            
                            <td><?php echo html_escape($i); ?></td>
                            
                            <td><?php echo my_date_show($payment->created_at); ?> </td>

                            <td><?php echo get_by_id($payment->session_id, 'sessions')->name; ?> </td>



                            <?php $mentor = get_by_id($payment->user_id, 'users') ?>
                            <?php if ($mentor->thumb == ''): ?>
                                <?php $avatar = 'assets/images/avatar.png'; ?> 
                            <?php else: ?>
                                <?php $avatar = $mentor->thumb; ?>
                            <?php endif ?>
                            <td>
                              <img width="40px" class="img-circle mr-2" src="<?php echo base_url($avatar) ?>"> 
                              <?php echo ucfirst($mentor->name); ?>
                            </td>




                            <?php $customer = get_by_id($payment->customer_id, 'users') ?>
                            <?php if ($customer->thumb == ''): ?>
                                <?php $avatar = 'assets/images/avatar.png'; ?> 
                            <?php else: ?>
                                <?php $avatar = $customer->thumb; ?>
                            <?php endif ?>
                            <td>
                              <img width="40px" class="img-circle mr-2" src="<?php echo base_url($avatar) ?>"> 
                              <?php echo ucfirst($customer->name); ?>
                            </td>

                            <td>

                              <?php if(settings()->curr_locate == 0){echo settings()->currency_symbol;} ?>
                                <?php echo number_format($payment->commission_amount, settings()->num_format) ?>
                                <?php if(settings()->curr_locate == 1){echo settings()->currency_symbol;} ?>
                            </td>

                            <td>

                              <?php if(settings()->curr_locate == 0){echo settings()->currency_symbol;} ?>
                                <?php echo number_format($payment->total_amount, settings()->num_format) ?>
                                <?php if(settings()->curr_locate == 1){echo settings()->currency_symbol;} ?>
                            </td>

                            <td>
                              <?php if ($payment->status == 'verified'): ?>
                                <span class="badge badge-success-soft brd-20"><i class="fas fa-check-circle"></i> <?php echo trans('paid') ?></span>
                              <?php else: ?>
                                <span class="badge badge-warning-soft brd-20"> <?php echo ucfirst($payment->status); ?></span>
                              <?php endif ?>
                            </td>

                            <td>
                              <span class="badge badge-primary brd-20"><i class="bi bi-credit-card"></i> <?php echo ucfirst($payment->payment_method); ?></span>
                            </td>
                            
                            <?php if(is_admin()): ?>
                              <td class="actions">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-tool" data-toggle="dropdown" aria-expanded="false">
                                      <i class="fas fa-ellipsis-h"></i>
                                    </button>

                                    <div class="dropdown-menu dropdown-menu-right" role="menu" >
                                      <?php if (!empty($payment->proof)): ?>
                                        <?php if ($payment->status == 'pending'): ?>
                                          <a href="<?php echo base_url('admin/payment/approve_offline_customer/'.$payment->id) ?>" class="dropdown-item"><i class="far fa-check-circle"></i> <?php echo trans('approve-payment') ?></a>
                                        <?php endif ?>

                                        <a target="_blank" href="<?php echo base_url('uploads/files/'.$payment->proof) ?>" class="dropdown-item"><i class="far fa-file-alt"></i> <?php echo trans('view-proof') ?></a>
                                      <?php endif ?>

                                      <a target="_blank" href="<?php echo base_url('admin/payment/customer_receipt/'.$payment->puid) ?>" class="dropdown-item"><i class="far fa-eye"></i> <?php echo trans('view-invoice') ?></a>
                                    </div>
                                </div>

                              </td>
                            <?php endif; ?>
                        </tr>
                      <?php endif ?>
                      
                    <?php $i++; endforeach; ?>
                  </tbody>
              </table>
          </div>
        <?php else: ?>
          <?php $this->load->view('admin/include/not-found'); ?>
        <?php endif; ?>
      </div>
    </div>
  </section>
</div>

<style>
.export-group {
  display: flex;
  gap: 10px;
  align-items: center;
}

.export-btn {
  display: flex;
  align-items: center;
  gap: 8px;
  padding: 8px 16px;
  border-radius: 6px;
  font-weight: 500;
  text-decoration: none;
  transition: all 0.2s ease;
}

.csv-btn {
  background: #28a745;
  color: white;
}

.excel-btn {
  background: #1a5f7a;
  color: white;
}

.export-btn:hover {
  transform: translateY(-1px);
  box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
  color: white;
}

.export-btn i {
  font-size: 1.1em;
}

.export-btn span {
  font-size: 0.9em;
}

.nav-tabs-custom .nav-link {
  border-radius: 50px;
  padding: 8px 20px;
  color: #6c757d;
  font-weight: 500;
  transition: all 0.3s ease;
}

.nav-tabs-custom .nav-link:hover {
  color: #495057;
  background: rgba(0,0,0,0.05);
}

.nav-tabs-custom .nav-link.active {
  background: #fff;
  color: #007bff;
  box-shadow: 0 2px 8px rgba(0,0,0,0.08);
}

.nav-tabs-wrapper {
  border-bottom: none;
}
</style>
