<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Users extends Home_Controller {

	public function __construct()
    {
        parent::__construct();
        if (!is_admin()) {
            redirect(base_url());
        }
    }


    public function index()
    {
        $this->all_users('all');
    }

    public function all_users($type)
    {

        $data = array();
        $this->load->library('pagination');
        $tab = $this->input->get('t') == 'prime' ? true : false;
        $config['base_url'] = base_url('admin/users/all_users/'.$type);
        $total_row = $this->admin_model->get_all_users(1 , 0, 0, $type, $tab);
        $config['total_rows'] = $total_row;
        $config['per_page'] = 15;
        $this->pagination->initialize($config);
        
        $page = $this->security->xss_clean($this->input->get('page'));
        if (empty($page)) {
            $page = 0;
        }
        if ($page != 0) {
            $page = $page - 1;
        }

        $data['page_title'] = 'Users';
        $data['countries'] = $this->admin_model->select('country');
        $data['categories'] = $this->admin_model->select('categories');
        $data['users'] = $this->admin_model->get_all_users(0 , $config['per_page'], $page * $config['per_page'], $type, $tab);
        $data['main_content'] = $this->load->view('admin/users', $data, TRUE);
        $this->load->view('admin/index', $data);
    }

    public function mentor_details($id)
    {
        $data = array();
        $data['page'] = 'Users';   
        $data['page_title'] = 'Mentor Details';   
        $data['mentor'] = $this->admin_model->get_by_id($id, 'users');
        $data['sessions'] = $this->admin_model->get_mentor_sessions($data['mentor']->id);
        //echo '<pre>'; print_r($data['sessions']); exit();
        $data['main_content'] = $this->load->view('admin/user/mentor_details',$data,TRUE);
        $this->load->view('admin/index',$data);
    }

    public function mentees()
    {
        $data = array();
        $this->load->library('pagination');
        $config['base_url'] = base_url('admin/users/mentee');
        $total_row = $this->admin_model->get_all_mentees(1 , 0, 0);
        $config['total_rows'] = $total_row;
        $config['per_page'] = 15;
        $this->pagination->initialize($config);
        
        $page = $this->security->xss_clean($this->input->get('page'));
        if (empty($page)) {
            $page = 0;
        }
        if ($page != 0) {
            $page = $page - 1;
        }

        $data['page_title'] = 'Mentee';
        $data['packages'] = $this->admin_model->select('package');
        $data['users'] = $this->admin_model->get_all_mentees(0 , $config['per_page'], $page * $config['per_page']);
        $data['main_content'] = $this->load->view('admin/mentees', $data, TRUE);
        $this->load->view('admin/index', $data);
    }
 public function status_isprime($type, $id) 
    {
        $url = base_url('admin/users');
        $data = array(
            'isprime' => $type
        );
        $data = $this->security->xss_clean($data);
        $this->admin_model->update($data, $id,'users');
        if($type == 1):
            $this->session->set_flashdata('msg', trans('activate-prime-successfully')); 
        else:
            $this->session->set_flashdata('msg', trans('deactivate-prime-successfully')); 
        endif;

        redirect($url);
    }

    public function status_action($type, $id) 
    {

        $user = $this->admin_model->get_by_id($id, 'users');

        if ($user->role == 'user') {
            $url = base_url('admin/users');
        }else{
            $url = base_url('admin/mentee/all');
        }

        $data = array(
            'status' => $type
        );
        $data = $this->security->xss_clean($data);
        $this->admin_model->update($data, $id,'users');

        if($type == 1):

            if ($user->role == 'user') {
                $data = array();
                $data['name'] = $user->name;
                $message = $this->load->view('email_template/approved', $data, true);
                $this->email_model->send_email($user->email, $data['name'], $message);
            }

            $this->session->set_flashdata('msg', trans('activate-successfully')); 
        else:
            $this->session->set_flashdata('msg', trans('deactivate-successfully')); 
        endif;

        redirect($url);
    }

    public function change_account($id) 
    {
        $data = array(
            'account_type' => $this->input->post('type', false)
        );
        $data = $this->security->xss_clean($data);
        $this->admin_model->edit_option($data, $id, 'users');
        $this->session->set_flashdata('msg', trans('updated-successfully')); 
        redirect(base_url('admin/users'));
    }

    public function edit($id)
    {

        $data = array();

        $data['page_title'] = 'Users';
        $data['categories'] = $this->admin_model->get_site_categories('categories');
        $data['skills'] = $this->admin_model->get_site_skills('skills');
        $data['user'] = $this->admin_model->get_by_id($id,'users');
        $data['user_skills'] = $this->admin_model->get_skill_by_user($id);
        $data['countries'] = $this->admin_model->select_asc('country');
        $data['time_zones'] = $this->admin_model->select_asc('time_zone');
        $data['main_content'] = $this->load->view('admin/edit_mentor', $data, TRUE);
        $this->load->view('admin/index', $data);
    }

    public function update_mentor(){
        check_status();

        $id = $this->input->post('id');

        $skills = $this->input->post('skill');


        $this->admin_model->skill_delete($id,'users_skill');

        foreach ($skills as $skill) {
            $udata = array(
                'user_id' => $id,
                'skill_id' => $skill,
            );
      
            $udata = $this->security->xss_clean($udata);
            $this->admin_model->insert($udata, 'users_skill');
        }


        $data = array(
            'name' => $this->input->post('name', true),
            'email' => $this->input->post('email', true),
            'phone' => $this->input->post('phone', true),
            'gender' => $this->input->post('gender', true),
            'language' => $this->input->post('language', true),
            'country' => $this->input->post('country', true),
            'time_zone' => $this->input->post('time_zone', true),
            'respond_in' => $this->input->post('respond_in', true),
            'respond_time' => $this->input->post('respond_time', true),
            'level' => $this->input->post('level', true),
            'experience_year' => $this->input->post('experience_year', true),
            'company' => $this->input->post('company', true),
            'category' => $this->input->post('category', true),
            'designation' => $this->input->post('designation', true),
        );
  
        $data = $this->security->xss_clean($data);
        $this->admin_model->edit_option($data, $id, 'users');
        $this->session->set_flashdata('msg', trans('updated-successfully'));

        redirect(base_url('admin/mentors'));
    }


    public function reset($id)
    {
        $data=array(
            'password' => hash_password('1234')
        );
        $data = $this->security->xss_clean($data);
        $this->admin_model->edit_option($data, $id, 'users');
        $this->session->set_flashdata('msg', 'Password reset successfully');
        redirect(base_url('admin/users'));
        
    }


    public function delete($user_id)
    {
        check_status();
        $this->admin_model->delete($user_id,'users'); 
        echo json_encode(array('st' => 1));
        
    }

    public function update_position()
    {
        if (!$this->input->is_ajax_request()) {
            exit('No direct script access allowed');
        }
        
        $order = $this->input->post('order');
        foreach ($order as $position => $user_id) {
            $data = [
                'position' => $position + 1,
            ];
            $this->admin_model->update($data, $user_id, 'users');
        }
        echo json_encode(['status' => 'success', 'message' => 'Order updated successfully']);
    }

    /**
     * Build mentor export rows (for CSV/Excel)
     */
    protected function get_mentor_export_rows($mentors) {
        $rows = array();
        foreach ($mentors as $mentor) {
            $country = $this->admin_model->get_by_id($mentor->country, 'country');
            $country_name = $country && isset($country->name) ? $country->name : '';
            
            $usrcategory = explode(',', $mentor->category);
            $cname = [];
            foreach($usrcategory as $uid){
                $category = $this->admin_model->get_by_id($uid, 'categories');
                if($category && isset($category->name)) {
                    $cname[] = $category->name;
                }
            }
            $category_name = implode(', ', $cname);

            $skills = $this->admin_model->get_skill_by_user($mentor->id);
            $skill_names = '';
            if (!empty($skills)) {
                foreach ($skills as $skill) {
                    $skill_info = $this->admin_model->get_by_id($skill->skill_id, 'skills');
                    if ($skill_info) {
                        $skill_names .= $skill_info->skill.', ';
                    }
                }
                $skill_names = rtrim($skill_names, ', ');
            }
            
            $linkedin = !empty($mentor->linkedin_profile) ? $mentor->linkedin_profile : '';
            $twitter = !empty($mentor->x_profile) ? $mentor->x_profile : '';
            $instagram = !empty($mentor->instagram_profile) ? $mentor->instagram_profile : '';
            $facebook = !empty($mentor->facebook_profile) ? $mentor->facebook_profile : '';
            $kyc_status = ($mentor->kyc_verified == 1) ? 'Verified' : 'Pending';
            $currency = settings()->currency_code;
            $balance = number_format($mentor->balance/100, 2);
            $total_earnings = total_earnings($mentor->id);
            $total_withdraw = $total_earnings - $balance;
            $status = ($mentor->status == 1) ? 'Active' : (($mentor->status == 2) ? 'Disabled' : 'Pending');
            $rows[] = [
                $mentor->name,
                $mentor->email,
                $mentor->phone,
                $country_name,
                $category_name,
                $skill_names,
                $mentor->experience_year.' years',
                $linkedin,
                $twitter,
                $instagram,
                $facebook,
                $kyc_status,
                $currency.' '.$balance,
                $currency.' '.$total_earnings,
                $currency.' '.$total_withdraw,
                $status,
                date('Y-m-d', strtotime($mentor->created_at)),
                $mentor->isprime == 1 ? 'Yes' : 'No'
            ];
        }
        return $rows;
    }

    /**
     * Build mentee export rows (for CSV/Excel)
     */
    protected function get_mentee_export_rows($mentees) {
        $rows = array();
        foreach ($mentees as $mentee) {
            $country = $this->admin_model->get_by_id($mentee->country, 'country');
            $country_name = $country ? $country->name : '';
            $status = ($mentee->status == 1) ? 'Active' : 'Inactive';
            $joined_date = date('Y-m-d', strtotime($mentee->created_at));
            $last_active = !empty($mentee->last_active) ? get_time_ago($mentee->last_active) : 'Never';
            $rows[] = [
                $mentee->name,
                $mentee->email,
                $country_name,
                $last_active,
                $status,
                $joined_date
            ];
        }
        return $rows;
    }

    public function export_mentors($format = 'csv')
    {
        check_status();
        error_reporting(E_ALL);
        ini_set('display_errors', 4);
        $search = $this->input->get('search');
        $country = $this->input->get('country');
        $category = $this->input->get('category');
        $tab = $this->input->get('t') == 'prime' ? true : false;
        $mentors = $this->admin_model->get_all_users(0, 0, 0, 'all', $tab);
        if (!empty($search) || !empty($country) || !empty($category)) {
            $filtered_mentors = array();
            foreach ($mentors as $mentor) {
                $include = true;
                if (!empty($search) && stripos($mentor->name, $search) === false && stripos($mentor->email, $search) === false) {
                    $include = false;
                }
                if (!empty($country) && $country != 'all' && $mentor->country != $country) {
                    $include = false;
                }
                if (!empty($category) && $category != 'all') {
                    $mentor_categories = explode(',', $mentor->category);
                    if (!in_array($category, $mentor_categories)) {
                        $include = false;
                    }
                }
                if ($include) {
                    $filtered_mentors[] = $mentor;
                }
            }
            $mentors = $filtered_mentors;
        }
        $filename = 'mentors_export_'.date('Y-m-d');
        $header = ["Name","Email","Phone","Country","Category","Skills","Experience","LinkedIn","Twitter","Instagram","Facebook","KYC Status","Balance","Total Earnings","Total Withdraw","Status","Joined Date","Is Prime Account"];
        $rows = $this->get_mentor_export_rows($mentors);
        // CSV export
        if ($format == 'csv') {
            $this->load->helper('file');
            $this->load->helper('download');
            $csv_content = implode(',', $header) . "\n";
            foreach ($rows as $row) {
                $escaped = array_map(function($v) { return '"'.str_replace('"', '""', $v).'"'; }, $row);
                $csv_content .= implode(',', $escaped) . "\n";
            }
            force_download("$filename.csv", $csv_content);
        }
        // Excel export
        elseif ($format == 'excel') {
            if (!class_exists('PhpOffice\\PhpSpreadsheet\\Spreadsheet')) {
                require_once FCPATH . 'vendor/autoload.php';
            }
            if (ob_get_length()) ob_end_clean();
            $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();
            // Headers
            $col = 'A';
            foreach ($header as $h) {
                $sheet->setCellValue($col.'1', $h);
                $col++;
            }
            // Style header
            $sheet->getStyle('A1:P1')->applyFromArray(['font' => ['bold' => true]]);
            // Data rows
            $rownum = 2;
            foreach ($rows as $row) {
                $col = 'A';
                foreach ($row as $cell) {
                    $sheet->setCellValueExplicit($col . $rownum, $cell, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
                    $col++;
                }
                $rownum++;
            }
            foreach(range('A','P') as $col) {
                $sheet->getColumnDimension($col)->setAutoSize(true);
            }
            $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="'.$filename.'.xlsx"');
            header('Cache-Control: max-age=0');
            $writer->save('php://output');
            exit;
        }
    }

    public function export_mentees($format = 'csv')
    {
        check_status();
        error_reporting(E_ALL);
        ini_set('display_errors', 4);
        $search = $this->input->get('search');
        $package = $this->input->get('package');
        $sort = $this->input->get('sort');
        $mentees = $this->admin_model->get_all_mentees(0, 0, 0);
        if (!empty($search) || !empty($package) || !empty($sort)) {
            $filtered_mentees = array();
            foreach ($mentees as $mentee) {
                $include = true;
                if (!empty($search) && stripos($mentee->name, $search) === false && stripos($mentee->email, $search) === false) {
                    $include = false;
                }
                if (!empty($package) && $package != 'all' && $mentee->package_id != $package) {
                    $include = false;
                }
                if (!empty($sort) && $sort != 'all') {
                    if ($sort == 'verified' && $mentee->payment_status != 'verified') {
                        $include = false;
                    } elseif ($sort == 'pending' && $mentee->payment_status != 'pending') {
                        $include = false;
                    } elseif ($sort == 'expired' && $mentee->payment_status != 'expired') {
                        $include = false;
                    }
                }
                if ($include) {
                    $filtered_mentees[] = $mentee;
                }
            }
            $mentees = $filtered_mentees;
        }
        $filename = 'mentees_export_'.date('Y-m-d');
        $header = ["Name","Email","Country","Last Active","Status","Joined Date"];
        $rows = $this->get_mentee_export_rows($mentees);
        // CSV export
        if ($format == 'csv') {
            $this->load->helper('file');
            $this->load->helper('download');
            $csv_content = implode(',', $header) . "\n";
            foreach ($rows as $row) {
                $escaped = array_map(function($v) { return '"'.str_replace('"', '""', $v).'"'; }, $row);
                $csv_content .= implode(',', $escaped) . "\n";
            }
            force_download("$filename.csv", $csv_content);
        }
        // Excel export
        elseif ($format == 'excel') {
            if (!class_exists('PhpOffice\\PhpSpreadsheet\\Spreadsheet')) {
                require_once FCPATH . 'vendor/autoload.php';
            }
            if (ob_get_length()) ob_end_clean();
            $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();
            // Headers
            $col = 'A';
            foreach ($header as $h) {
                $sheet->setCellValue($col.'1', $h);
                $col++;
            }
            // Style header
            $sheet->getStyle('A1:F1')->applyFromArray(['font' => ['bold' => true]]);
            // Data rows
            $rownum = 2;
            foreach ($rows as $row) {
                $col = 'A';
                foreach ($row as $cell) {
                    $sheet->setCellValue($col.$rownum, $cell);
                    $col++;
                }
                $rownum++;
            }
            foreach(range('A','F') as $col) {
                $sheet->getColumnDimension($col)->setAutoSize(true);
            }
            $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="'.$filename.'.xlsx"');
            header('Cache-Control: max-age=0');
            $writer->save('php://output');
            exit;
        }
    }

    public function import_mentors() 
    {
        check_status();
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $upload_dir = './uploads/temp/';
            if (!is_dir($upload_dir)) {
                if (!mkdir($upload_dir, 0777, true)) {
                    $this->session->set_flashdata('error', 'Failed to create upload directory. Please check permissions.');
                    redirect(base_url('admin/users'));
                }
            }
            $config['upload_path'] = $upload_dir;
            $config['allowed_types'] = 'csv|xlsx|xls';
            $config['max_size'] = '5000'; // 5MB max

            $this->load->library('upload', $config);
            
            if (!$this->upload->do_upload('import_file')) {
                $this->session->set_flashdata('error', $this->upload->display_errors());
                redirect(base_url('admin/users'));
            } else {
                $file_data = $this->upload->data();
                $file_path = $upload_dir.$file_data['file_name'];
                
                $import_result = $this->process_import($file_path, 'mentor', $file_data['file_ext']);
                
                if (file_exists($file_path)) {
                    unlink($file_path);
                }
                
                if ($import_result['status'] == 'success') {
                    $this->session->set_flashdata('msg', $import_result['message']);
                } else {
                    $this->session->set_flashdata('error', $import_result['message']);
                }
                
                redirect(base_url('admin/users'));
            }
        } else {
            $data = array();
            $data['page_title'] = 'Import Mentors';
            $data['main_content'] = $this->load->view('admin/import_mentors', $data, TRUE);
            $this->load->view('admin/index', $data);
        }
    }

    public function import_mentees() 
    {
        check_status();

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $upload_dir = './uploads/temp/';
            if (!is_dir($upload_dir)) {
                if (!mkdir($upload_dir, 0777, true)) {
                    $this->session->set_flashdata('error', 'Failed to create upload directory. Please check permissions.');
                    redirect(base_url('admin/users/mentees'));
                }
            }
            $config['upload_path'] = $upload_dir;
            $config['allowed_types'] = 'csv|xlsx|xls';
            $config['max_size'] = '5000'; // 5MB max
            
            $this->load->library('upload', $config);
            
            if (!$this->upload->do_upload('import_file')) {
                $this->session->set_flashdata('error', $this->upload->display_errors());
                redirect(base_url('admin/users/mentees'));
            } else {
                $file_data = $this->upload->data();
                $file_path = $upload_dir.$file_data['file_name'];
                
                $import_result = $this->process_import($file_path, 'mentee', $file_data['file_ext']);
                
                if (file_exists($file_path)) {
                    unlink($file_path);
                }
                
                if ($import_result['status'] == 'success') {
                    $this->session->set_flashdata('msg', $import_result['message']);
                } else {
                    $this->session->set_flashdata('error', $import_result['message']);
                }
                
                redirect(base_url('admin/users/mentees'));
            }
        } else {
            $data = array();
            $data['page_title'] = 'Import Mentees';
            $data['main_content'] = $this->load->view('admin/import_mentees', $data, TRUE);
            $this->load->view('admin/index', $data);
        }
    }

    public function download_mentor_template($format = 'excel')
    {
        check_status();
        $this->load->helper('download');
        $filename = 'mentor_import_template_'.date('Y-m-d');
        if ($format == 'csv') {
            $header = "Name,Email,Phone,Country,Category,Experience,Password\n";
            $sample = "John Doe,john@example.com,1234567890,79,1,5,password123\n";
            $content = "$header$sample";
            force_download("$filename.csv", $content);
        } elseif ($format == 'excel') {
            if (file_exists(FCPATH . 'vendor/autoload.php')) {
                require_once FCPATH . 'vendor/autoload.php';
                $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
                $sheet = $spreadsheet->getActiveSheet();
                $headers = ['Name', 'Email', 'Phone', 'Country', 'Category', 'Experience', 'Password'];
                $col = 'A';
                foreach ($headers as $header) {
                    $sheet->setCellValue($col . '1', $header);
                    $col++;
                }
                $sheet->setCellValue('A2', 'John Doe');
                $sheet->setCellValue('B2', 'john@example.com');
                $sheet->setCellValue('C2', '1234567890');
                $sheet->setCellValue('D2', '79');
                $sheet->setCellValue('E2', '1,2');
                $sheet->setCellValue('F2', '5');
                $sheet->setCellValue('G2', 'password123');
               
               // Auto size columns
                foreach(range('A','G') as $col) {
                    $sheet->getColumnDimension($col)->setAutoSize(true);
                }

                // Create Excel writer
                $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);

                // Set headers for download
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header('Content-Disposition: attachment;filename="'.$filename.'.xlsx"');
                header('Cache-Control: max-age=0');

                // Save to PHP output
                $writer->save('php://output');
                exit;
            } else {
                $this->session->set_flashdata('error', 'Excel template is not available. PhpSpreadsheet library is missing.');
                redirect(base_url('admin/users'));
            }
        }
    }

    public function download_mentee_template($format = 'excel')
    {
        check_status();
        
        $this->load->helper('download');
        
        $filename = 'mentee_import_template_'.date('Y-m-d');
        
        if ($format == 'csv') {
            $header = "Name,Email,Phone,Country,Password\n";
            $sample = "John Doe,john@example.com,1234567890,79,password123\n";
            $content = "$header$sample";
            force_download("$filename.csv", $content);
        } elseif ($format == 'excel') {
            if (file_exists(FCPATH . 'vendor/autoload.php')) {
                require_once FCPATH . 'vendor/autoload.php';
                
                $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
                $sheet = $spreadsheet->getActiveSheet();
                
                // Headers
                $headers = ['Name', 'Email', 'Phone', 'Country', 'Password'];
                $col = 'A';
                foreach ($headers as $header) {
                    $sheet->setCellValue($col . '1', $header);
                    $col++;
                }
                
                $sheet->setCellValue('A2', 'John Doe');
                $sheet->setCellValue('B2', 'john@example.com');
                $sheet->setCellValue('C2', '1234567890');
                $sheet->setCellValue('D2', '79');
                $sheet->setCellValue('E2', 'password123');
                
                // Auto size columns
                foreach(range('A','E') as $col) {
                    $sheet->getColumnDimension($col)->setAutoSize(true);
                }
                
                // Create Excel writer
                $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
                
                // Set headers for download
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header('Content-Disposition: attachment;filename="'.$filename.'.xlsx"');
                header('Cache-Control: max-age=0');
                
                // Save to PHP output
                $writer->save('php://output');
                exit;
            } else {
                $this->session->set_flashdata('error', 'Excel template is not available. PhpSpreadsheet library is missing.');
                redirect(base_url('admin/users/mentees'));
            }
        }
    }

    private function process_import($file_path, $user_type, $file_ext)
    {
        $imported = 0;
        $failed = 0;
        $errors = [];
        $max_records = 100;
        
        if ($file_ext == '.csv') {
            $file = fopen($file_path, 'r');
            // Skip header row
            $header = fgetcsv($file);
            $records = [];
            $count = 0;
            while (($row = fgetcsv($file)) !== FALSE && $count < $max_records) {
                $records[] = $row;
                $count++;
            }
            fclose($file);
        } else if (in_array($file_ext, ['.xlsx', '.xls'])) {
            require_once FCPATH . 'vendor/autoload.php';
            $reader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader(ucfirst(substr($file_ext, 1)));
            $spreadsheet = $reader->load($file_path);
            $worksheet = $spreadsheet->getActiveSheet();
            $rows = $worksheet->toArray();
            // Remove header row
            array_shift($rows);
            $records = [];
            foreach ($rows as $row) {
                if (!empty($row[0]) && !empty($row[1])) {
                    $records[] = $row;
                }

                if (count($records) >= $max_records) {
                    break;
                }
            }
        } else {
            return [
                'status' => 'error',
                'message' => 'Invalid file format. Please upload a CSV or Excel file.',
                'imported' => 0,
                'failed' => 0,
                'errors' => ['Invalid file format']
            ];
        }

        if (empty($records)) {
            return [
                'status' => 'error',
                'message' => 'No valid records found in the file. Please check your file and try again.',
                'imported' => 0,
                'failed' => 0,
                'errors' => ['No valid records found']
            ];
        }

        foreach ($records as $record) {
            $user_data = [];
            if ($user_type == 'mentor') {
                if (empty($record[0]) || empty($record[1]) || empty($record[6])) {
                    $failed++;
                    $errors[] = "Missing required fields for " . (!empty($record[1]) ? $record[1] : 'unknown email') . ". Name, Email, and Password are required.";
                    continue;
                }
                
                $existing_user = $this->admin_model->check_email($record[1]);
                if ($existing_user) {
                    $failed++;
                    $errors[] = "Email already exists: $record[1]";
                    continue;
                }

                $slug = url_title($record[0], 'dash', TRUE);

                $user_data = [
                    'name' => $record[0],
                    'user_name' => $slug,
                    'slug' => $slug,
                    'email' => $record[1],
                    'phone' => $record[2] ?? '',
                    'country' => $record[3] ?? '',
                    'category' => $record[4] ?? '',
                    'experience_year' => $record[5] ?? '',
                    'password' => hash_password($record[6]),
                    'role' => 'user',
                    'status' => 1,
                    'is_active' => 1,
                    'email_verified' => 1,
                    'created_at' => date('Y-m-d H:i:s')
                ];
            } else {
                if (empty($record[0]) || empty($record[1]) || empty($record[4])) {
                    $failed++;
                    $errors[] = "Missing required fields for " . (!empty($record[1]) ? $record[1] : 'unknown email') . ". Name, Email, and Password are required.";
                    continue;
                }
                $existing_user = $this->admin_model->check_email($record[1]);
                if ($existing_user) {
                    $failed++;
                    $errors[] = "Email already exists: " . $record[1];
                    continue;
                }
                $slug = url_title($record[0], 'dash', TRUE);
                $user_data = [
                    'name' => $record[0],
                    'user_name' => $slug,
                    'slug' => $slug,
                    'email' => $record[1],
                    'phone' => $record[2] ?? '',
                    'country' => $record[3] ?? '',
                    'password' => hash_password($record[4]),
                    'role' => 'mentee',
                    'status' => 1,
                    'is_active' => 1,
                    'email_verified' => 1,
                    'created_at' => date('Y-m-d H:i:s')
                ];
            }
            
            $this->db->trans_start();
            $user_id = $this->admin_model->insert($user_data, 'users');
            $this->db->trans_complete();
            if ($this->db->trans_status() === FALSE) {
                $failed++;
                $errors[] = "Database error importing $record[1]";
            } else {
                $imported++;
            }
        }

        if ($imported > 0) {
            $status = 'success';
            $message = "Successfully imported $imported " . ($user_type == 'mentor' ? 'mentors' : 'mentees');
            if ($failed > 0) {
                $message .= ", $failed records failed.";
                if (!empty($errors)) {
                    $message .= " Errors: " . implode("; ", array_slice($errors, 0, 3));
                    if (count($errors) > 3) {
                        $message .= " and " . (count($errors) - 3) . " more errors.";
                    }
                }
            }
        } else {
            $status = 'error';
            $message = "Import failed. No records were imported.";
            if (!empty($errors)) {
                $message .= " Errors: " . implode("; ", array_slice($errors, 0, 3));
                if (count($errors) > 3) {
                    $message .= " and " . (count($errors) - 3) . " more errors.";
                }
            }
        }
        return [
            'status' => $status,
            'message' => $message,
            'imported' => $imported,
            'failed' => $failed,
            'errors' => $errors
        ];
    }
}
