<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Sessions extends Home_Controller {

    public function __construct()
    {
        parent::__construct();
        if (!is_user() && !is_mentee() && !is_admin()) {
            redirect(base_url());
        }
        $this->load->library('zoom/zoom');
    }

    public function index()
    {
        
        $data = array();
        $data['page_title'] = 'Session';
        $data['page'] = 'Session';
        $data['session'] = FALSE;
        $data['sessionuser'] = FALSE;
        $data['working_days'] = $this->admin_model->get_user_days_active(user()->id);
        $data['skills'] = $this->admin_model->get_by_user('users_skill');
        $data['sessions'] = $this->admin_model->get_user_sessions(user()->id);
        $data['main_content'] = $this->load->view('admin/user/sessions',$data,TRUE);
        $this->load->view('admin/index',$data);
    }

    public function usersession($userid='')
    {  
        $data = array();
        $data['page_title'] = 'Session';
        $data['page'] = 'Session';
        $data['session'] = FALSE;
        $data['sessionuser']=$userid;
        $data['skills'] = $this->admin_model->get_by_user('users_skill');
        $data['sessions'] = $this->admin_model->get_user_sessions($userid);
        $data['working_days'] =$this->admin_model->get_user_days_active($userid);
        $data['my_days'] =$this->admin_model->get_user_days(user()->id,$userid);
        $data['main_content'] = $this->load->view('admin/user/sessions',$data,TRUE);
        $this->load->view('admin/index',$data);
    }
    public function add()
    {   
        
        check_status();
        
        if($_POST)
        {   

            // $count_session = $this->admin_model->count_free_session(user()->id);
            // if ($count_session > 0 && $this->input->post('price') == 0) {
            //     $this->session->set_flashdata('error', trans('free-session-limit'));
            //     redirect(base_url('admin/sessions'));
            // }

            $check_slug = check_session_slug(str_slug($this->input->post('name', true)));
            $random_slug_code = random_string('numeric', 3);
            if($check_slug == 1){
                $slug = str_slug($this->input->post('name', true)).'-'.$random_slug_code; 
            }else{
                $slug = str_slug($this->input->post('name', true));
            }

            $id = $this->input->post('id', true);

            $is_default = 1;
            if (empty($this->input->post('is_default'))) {
                $is_default = 1;
            }else{
                $is_default = $this->input->post('is_default');
            }



            if (settings()->minimum_session_price != 0) {
                $price_type = $this->input->post('session_price_type', true);

                if ($price_type == 0) {
                    $price = 0;
                }else{
                    $price = $this->input->post('price',true);

                    if ($price < settings()->minimum_session_price) {
                        
                        $error_msg = trans('price-must-be').' '.settings()->minimum_session_price.' '. trans('or-more');
                        $this->session->set_flashdata('error', $error_msg); 
                         redirect(base_url('admin/sessions'));
                    }


                }
            }else{

                $price = $this->input->post('price', true);
            }



            $data=array(
                'user_id' =>user()->id,
                'type' => $this->input->post('type',true),
                'name' => $this->input->post('name',true),
                'slug' => $slug,
                'uid' => random_string('numeric', 8),
                'details' => $this->input->post('details',true),
                'duration' => $this->input->post('duration',true),
                'price' => $price,
                'total_slot' => $this->input->post('total_slot',true),
                'slot_for' => $this->input->post('slot_for',true),
                'session_number' => $this->input->post('session_number',true),
                'session_repeat' => $this->input->post('session_repeat',true),
                'skill_id' => $this->input->post('skill_id',true),
                'allow_session' => $this->input->post('allow_session',true),
                'is_public' => $this->input->post('is_public',true),
                'enable_group_booking' => $this->input->post('enable_group_booking',true),
                'group_booking_slot' => $this->input->post('group_booking_slot',true),
                'is_default' =>$is_default,
                'intro_video' =>$this->input->post('intro_video',true),
                'status' => $this->input->post('status',true),
                'created_at' =>my_date_now()
            );
            $data = $this->security->xss_clean($data);
            if ($id != '') {

                if ($is_default == 2) {
                    $this->admin_model->delete_session_assaign_days(user()->id, $id, 'assaign_days');
                    $this->admin_model->delete_session_assaign_time(user()->id, $id, 'assign_time');
                }
                

                $this->admin_model->edit_option($data, $id, 'sessions');
                $this->session->set_flashdata('msg', trans('updated-successfully')); 
            } else {
                $id = $this->admin_model->insert($data, 'sessions');
                $this->session->set_flashdata('msg', trans('inserted-successfully')); 
            }

            
            $session = $this->admin_model->get_by_id($id,'sessions');

            if($is_default == 2){
                for ($i=0; $i < 7; $i++) { 
                    if(empty($this->input->post("day_".$i))){
                        $day = 0;
                    }else{
                        $day = $this->input->post("day_".$i);
                    }
                    $data = array(
                        'user_id' => user()->id,
                        'session_id' => $id,
                        'day' => $day
                    );
                    $data = $this->security->xss_clean($data);
                    $this->admin_model->insert($data, 'assaign_days');

                    //insert times

                    $start = $this->input->post("start_time_".$i);
                    $end = $this->input->post("end_time_".$i);

                    if ($day != 0) {

                        $phpversion = phpversion();
                        if ($phpversion <= 8.0) {
                            for ($a=0; $a < count($start); $a++) { 
                                $time_data = array(
                                    'user_id' => user()->id,
                                    'session_id' => $id,
                                    'day_id' => $day,
                                    'time' => $start[$a].'-'.$end[$a],
                                    'start' => $start[$a],
                                    'end' => $end[$a],
                                    'person_per_slot' =>$session->group_booking_slot,
                                );
                                $time_data = $this->security->xss_clean($time_data);
                                $this->admin_model->insert($time_data, 'assign_time');
                            }
                        }else{
                            $time_count = isset($start) && is_array($start) ? count($start) : 0;
                            for ($a=0; $a < $time_count; $a++) {
                                $time_data = array(
                                    'user_id' => user()->id,
                                    'session_id' => $id,
                                    'day_id' => $day,
                                    'time' => $start[$a].'-'.$end[$a],
                                    'start' => $start[$a],
                                    'end' => $end[$a],
                                    'person_per_slot' =>$session->group_booking_slot,
                                );
                                $time_data = $this->security->xss_clean($time_data);
                                $this->admin_model->insert($time_data, 'assign_time');
                            }
                        }
                    }

                } 

            }

            if($_FILES['photo']['name'] != ''){
                $up_load = $this->admin_model->upload_image('1200');
                $data_img = array(
                    'image' => $up_load['images'],
                    'thumb' => $up_load['thumb']
                );
                $data_img = $this->security->xss_clean($data_img);
                $this->admin_model->edit_option($data_img, $id, 'sessions');
            }
            
            redirect(base_url('admin/sessions'));

        }      
        
    }
    

    public function edit($id)
    {  
        $data = array();
        $data['page_title'] = 'Edit';
        $data['page'] = 'Session';
         $data['suser']=FALSE;
        $data['skills'] = $this->admin_model->get_by_user('users_skill');
        $data['session'] = $this->admin_model->get_by_id($id, 'sessions');
        $data['working_days'] =$this->admin_model->get_user_days_active(user()->id);
        $data['my_days'] =$this->admin_model->get_user_days(user()->id,$id);
        $data['main_content'] = $this->load->view('admin/user/sessions',$data,TRUE);
        $this->load->view('admin/index',$data);
    }

    public function view($id,$userid)
    {  
        $data = array();
        $data['page_title'] = 'Edit';
        $data['page'] = 'Session';
        $data['suser']=$userid;
        $data['skills'] = $this->admin_model->get_by_user('users_skill');
        $data['session'] = $this->admin_model->get_by_id($id, 'sessions');
        $data['working_days'] =$this->admin_model->get_user_days_active($userid);
        $data['my_days'] =$this->admin_model->get_user_days($userid,$id);
        $data['main_content'] = $this->load->view('admin/user/sessions',$data,TRUE);
        $this->load->view('admin/index',$data);
    }
    public function delete($id)
    {
        $this->admin_model->delete($id,'sessions'); 
        echo json_encode(array('st' => 1));
    }



    public function booking($session_id='')
    {

        if (isset($_GET['role']) && $_GET['role'] == 'admin') {
            $this->session->set_userdata('admin_access', 'true');
            $mrole = 'booking_admin';
        }else{
            $mrole = 'booking';
        }

        if (!empty($this->session->userdata('admin_access')) && $this->session->userdata('admin_access') == 'true') {
            $mrole = 'booking_admin';
        }else{
            $mrole = 'booking';
        }
      
        $type = user()->role;
        
        $data = array();
        $data['page_title'] = 'Session Booking';
        $data['booking'] = FALSE;
        $data['type'] =  $type;
        $total_row = $this->admin_model->get_all_bookings($type, user()->id, $total=1, 0, 0);
        $config['total_rows'] = $total_row;
        $config['per_page'] = 10 ;
        $this->pagination->initialize($config);
        $page = $this->security->xss_clean($this->input->get('page'));
        if (empty($page)) {
            $page = 0;
        }
        if ($page != 0) {
            $page = $page - 1;
        }
        $data['bookings']=$this->admin_model->get_all_bookings($type, user()->id, $total=0, $config['per_page'], $page * $config['per_page']);
        $data['certificates']=$this->admin_model->get_all_certificates(user()->id, $total=0,0,1000);
        $data['sessions'] = $this->common_model->get_user_sessions(user()->id);
        $data['mentees'] = $this->common_model->get_all_mentees();
        $data['user_mentees'] = $this->common_model->get_all_user_mentees(user()->id);
        $data['mentee_mentors'] = $this->common_model->get_all_mentee_mentors(user()->id);
        $data['main_content'] = $this->load->view('admin/user/'.$mrole, $data,TRUE);
        $this->load->view('admin/index',$data);
    }

    public function userbooking($user,$session_id='')
    {
        $udata=$this->admin_model->get_by_id($user,'users');
        $type = $udata->role;
        $data = array();
        $data['page_title'] = 'Session Booking';
        $data['booking'] = FALSE;
        $data['userid'] = $udata;
        $data['type'] =  $type;
        $total_row = $this->admin_model->get_all_bookings($type, $user, $total=1, 0, 0);
        $config['total_rows'] = $total_row;
        $config['per_page'] = 10 ;
        $this->pagination->initialize($config);
        $page = $this->security->xss_clean($this->input->get('page'));
        if (empty($page)) {
            $page = 0;
        }
        if ($page != 0) {
            $page = $page - 1;
        }
        
        $data['bookings']=$this->admin_model->get_all_bookings($type, $user, $total=0, $config['per_page'], $page * $config['per_page']);
        $data['sessions'] = $this->common_model->get_user_sessions($user);
        $data['certificates']=$this->admin_model->get_all_certificates(user()->id, $total=0,0,1000);
        $data['mentees'] = $this->common_model->get_all_mentees();
        $data['user_mentees'] = $this->common_model->get_all_user_mentees($user);
        $data['mentee_mentors'] = $this->common_model->get_all_mentee_mentors($user);
        $data['main_content'] = $this->load->view('admin/user/booking',$data,TRUE);
        $this->load->view('admin/index',$data);
    }
    public function booking_payment($booking_id)
    {
        $data = array();
        $data['page_title'] = 'Booking Payment';
        $data['booking'] = $this->admin_model->get_by_md5_id($booking_id, 'session_booking');
        $mercado = $this->mercado_api_link($booking_id);
        $data['init'] = $mercado['init'];
        $data['main_content'] = $this->load->view('admin/user/payment',$data,TRUE);
        $this->load->view('admin/index',$data);
    }


    public function mercado_api_link($booking_id){

        $booking = $this->admin_model->get_by_md5_id($booking_id, 'session_booking');
        $user = $this->admin_model->get_by_id($booking->user_id, 'users');
        $this->session->set_userdata('booking_id', $booking->id);
      
        $mercado_token = settings()->mercado_token;
        $mercado_currency = settings()->mercado_currency;
        
        $coupon = check_coupon_mentee($booking->session_id, $booking->mentee_id);
        if(empty($coupon)){
          $session = $this->admin_model->get_by_id($booking->session_id, 'sessions');
          $totalCost = $booking->price;
        }else{
          $discount = $coupon->discount;
          $discount_amount = ($booking->price * $discount)/ 100 ;
          $totalCost = $booking->price - $discount_amount;
        }
       
        $data = [];
        MercadoPago\SDK::setAccessToken($mercado_token);
        $preference = new MercadoPago\Preference();
        // Create a preference item
        $item = new MercadoPago\Item();
        $item->title = 'Booking Payment - '.$booking->booking_number;
        $item->quantity = 1;
        $item->unit_price = $totalCost;
        $item->currency_id = $mercado_currency;
        $preference->items = array($item);
        $preference->back_urls = array(
            "success" => base_url("admin/payment/mercado"),
            "failure" => base_url("admin/payment/mercado"),
            "pending" => base_url("admin/payment/mercado")
        );
        $preference->auto_return = "approved";

        $preference->save();
        $data['f_id'] = $preference->id;
        $data['init'] = $preference->init_point;
        return $data;   
    }



    public function get_session_calendar($session_id)
    {
        $type = user()->role;
        $mentor_id = user()->id;

        $data = array();

        $data['session'] =  $this->common_model->get_single_session_by_id($session_id);
        
        if (isset($data['session']->is_default) && $data['session']->is_default == 2) {
            $my_days = $this->common_model->get_my_session_days($session_id);
            foreach ($my_days as $day) {
                if ($day['day'] != 0) {
                    $myday[] = $day['day'];
                }
            }

            $days = "1,2,3,4,5,6,7";         
            $days = explode(',', $days);
            $assign_days = $myday;

            $match = array();
            $nomatch = array();

            foreach($days as $v){     
                if(in_array($v, $assign_days))
                    $match[]=$v;
                else
                    $nomatch[]=$v;
            }
            $data['not_available'] = $nomatch;
            $data['my_days'] = $my_days;
        }else{
            $my_days = $this->common_model->get_my_session_days_default($mentor_id);
            foreach ($my_days as $day) {
                if ($day['day'] != 0) {
                    $myday[] = $day['day'];
                }
            }

            $days = "1,2,3,4,5,6,7";         
            $days = explode(',', $days);
            $assign_days = $myday;

            $match = array();
            $nomatch = array();

            foreach($days as $v){     
                if(in_array($v, $assign_days))
                    $match[]=$v;
                else
                    $nomatch[]=$v;
            }
            $data['not_available'] = $nomatch;
            $data['my_days'] = $my_days;
        }

        $holidays = json_decode(user()->holidays);


        foreach ($holidays as $value) {
            $date = $value;
            $dateTime = new DateTime($date);
            $formattedDate = $dateTime->format('Y-n-j');
            $holidays1[] = $formattedDate;
        }


        //echo "<pre>"; print_r($holidays1); exit();
        $data['holidays'] = $holidays1;
        $data['session_id'] = $data['session']->id;
        $data['page_title'] = 'Session Booking';
        $loaded=$this->load->view('admin/include/session_booking',$data,true);

        echo json_encode(array('st'=>1, 'loaded'=>$loaded));

        
    }


    public function booking_add()
    {   
        
        check_status();
        
        if($_POST)
        {   
            $id = $this->input->post('id', true);

            $session = $this->admin_model->get_by_id($this->input->post('session_id',true), 'sessions');
            $mentor = $this->admin_model->get_by_id($session->user_id, 'users');
            $mentee = $this->admin_model->get_by_id($this->input->post('mentee_id',true), 'users');
            $booking_number = random_string('numeric', 8);
            $booking_number = ltrim($booking_number, '0');
            
            $data=array(
                'user_id' =>user()->id,
                'session_id' => $this->input->post('session_id',true),
                'mentee_id' => $this->input->post('mentee_id',true),
                'booking_number' => $booking_number,
                'note' => $this->input->post('notes',true),
                'duration' => $session->duration,
                'price' => $session->price,
                'date' => $this->input->post('date',true),
                'time' => $this->input->post('time',true),
                'status' => 0,
                'meeting_type' => '', // Default empty, will be set when meeting is created
                'created_at' =>my_date_now()
            );
            $data = $this->security->xss_clean($data);

            if ($id != '') {
                $this->admin_model->edit_option($data, $id, 'session_booking');
                $this->session->set_flashdata('msg', trans('updated-successfully')); 
            } else {
                $id = $this->admin_model->insert($data, 'session_booking');
                $this->session->set_flashdata('msg', trans('inserted-successfully')); 
            }

            $notify = array(
                'user_id' => $this->input->post('mentee_id',true),
                'action_id' =>$this->input->post('mentee_id',true),
                'content_id' =>$booking_number,
                'text' => "you have booked a session : " .'"'.$session->name.'" of ' .$mentor->name.'just now',
                'noti_type' => 2,
                'noti_time' => my_date_now()
            );
            $notify = $this->security->xss_clean($notify);
            $this->common_model->insert($notify, 'notifications');

            $subject =trans('appointment-confirmation').' - '.$mentor->name;
            $msg = "you have booked a session : " .'"'.$session->name.'" of ' .$mentor->name.'on '.$this->input->post('date', true).' at '.$this->input->post('time', true);
            $edata = array();
            $edata['subject'] = $subject;
            $edata['message'] = $msg;
            
            $message = $this->load->view('email_template/appointment', $edata, true);
            $response = $this->email_model->send_email($mentee->email, $subject, $message);

            redirect(base_url('admin/sessions/booking'));
        }      
    }


    public function booking_edit($id)
    {  
        $data = array();
        $data['page_title'] = 'Edit';
        $data['page'] = 'Session Booking';
        $data['sessions'] = $this->common_model->get_user_sessions(user()->id);
        $data['mentees'] = $this->common_model->get_all_mentees(); 
        $data['booking'] = $this->admin_model->get_by_id($id, 'session_booking');
        $data['certificates']=$this->admin_model->get_all_certificates(user()->id, $total=0,0,1000);
        $data['main_content'] = $this->load->view('admin/user/booking',$data,TRUE);
        $this->load->view('admin/index',$data);
    }

    public function booking_details($booking_id){
        
        $data = array();
        $data['page_title'] = 'Booking Details';
        $data['booking'] = FALSE;
        $data['booking'] = $this->admin_model->get_single_booking($booking_id);
        $data['session'] = $this->admin_model->get_by_id($data['booking']->session_id, 'sessions');
        $data['certificates']=$this->admin_model->get_all_certificates(user()->id, $total=0,0,1000);
        $data['main_content'] = $this->load->view('admin/user/booking_details',$data,TRUE);
        $this->load->view('admin/index',$data);
    }
    
     public function session_report(){
        if($_POST)
        {   
            $id = $this->input->post('booking_id',true);
            $booking_report = $this->input->post('booking_report',true);
            $data = array(
                'booking_report' => $booking_report
            );
            $this->admin_model->update($data, $id, 'session_booking');
            $this->session->set_flashdata('msg', trans('inserted-successfully')); 
            redirect(base_url('admin/sessions/booking/?search=completed'));
        }

    }

    public function status_update($status, $id) 
    {
        $data = array(
            'status' => $status
        );
        $this->admin_model->update($data, $id, 'session_booking');

        $booking = $this->admin_model->get_by_id($id,'session_booking');
        $session_name = $this->admin_model->get_by_id($booking->session_id,'sessions')->name;
        $mentor_name = $this->admin_model->get_by_id($booking->user_id,'users')->name;
        $mentee_email = $this->admin_model->get_by_id($booking->mentee_id,'users')->email;
      
        if($status == 1){
            $text = $mentor_name .' approved your booked session : ' .'"'.$session_name.'"';
            $status = 'Approved';
        }
        if($status == 2){
            $text = $mentor_name .' rejected your booked session : ' .'"'.$session_name.'"';
            $status = 'Reject';
        }
        if($status == 3){
            $text = 'The session you have booked : ' .'"'.$session_name.'" '.'has been completed';
            $status = 'Complete';
        }

        $notify = array(
            'user_id' => $booking->mentee_id,
            'action_id' =>$booking->user_id,
            'content_id' =>$booking->booking_number,
            'text' => $text,
            'noti_type' => 3,
            'noti_time' => my_date_now()
        );
        $notify = $this->security->xss_clean($notify);
        $this->common_model->insert($notify, 'notifications');

        $subject =trans('booking-status').' - '.$status;
        $msg = $text;
        $edata = array();
        $edata['subject'] = $subject;
        $edata['message'] = $msg;
            
        $message = $this->load->view('email_template/appointment', $edata, true);
        $response = $this->email_model->send_email($mentee_email, $subject, $message);
        echo json_encode(array('st' => 1));
    }


    public function booking_delete($id)
    {
        $this->admin_model->delete($id,'session_booking'); 
        echo json_encode(array('st' => 1));
    }

    public function booking_cancell($id) 
    {
        $data = array(
            'status' => 4
        );
        $this->admin_model->update($data, $id, 'session_booking');
        redirect($_SERVER['HTTP_REFERER']);
    }


    public function check_coupon($dcode, $booking_id) 
    {
        
        $booking = $this->admin_model->get_by_id($booking_id, 'session_booking');
        $session = $this->admin_model->get_by_id($booking->session_id, 'sessions');
        $coupon =  $this->admin_model->get_discount($dcode, $session->id, $session->user_id);


        if(empty($coupon)){
            echo json_encode(array('st' => 0, 'msg' => '<i class="fas fa-times-circle"></i> '.'Invalid Code')); exit();
        }else{

            if (date('Y-m-d') >= $coupon->start_date && date('Y-m-d') <= $coupon->end_date) {
                
                if ($coupon->usages_limit == 0) {
                    echo json_encode(array('st' => 0, 'msg' => '<i class="fas fa-times-circle"></i> '.'This coupon code has no limit')); exit();
                }

                if ($coupon->once_per_mentee == 1) {
                    $check = $this->admin_model->check_discount_apply($dcode, $session->id, $session->user_id, $booking->mentee_id);
                    if (isset($check)) {
                        echo json_encode(array('st' => 0, 'msg' => '<i class="fas fa-times-circle"></i> '.trans('already-applied-code'))); exit();
                    }
                }

                $price = $session->price;

                $data = array(
                    'code' => $dcode,
                    'coupon_id' => $coupon->id,
                    'discount' => $coupon->discount,
                    'session_id' => $session->id,
                    'user_id' => $session->user_id,
                    'session_id' => $booking->session_id,
                    'mentee_id' => $booking->mentee_id,
                    'booking_id' => $booking_id,
                    'created_at' => my_date_now()
                );
                $this->admin_model->insert($data, 'coupon_apply');

                //update coupon
                $discount_data = array(
                    'usages_limit' => $coupon->usages_limit - 1,
                    'used' => $coupon->used + 1
                );
                $this->admin_model->edit_option($discount_data, $coupon->id, 'coupons');
                echo json_encode(array('st' => 1, 'discount' => $coupon->discount, 'total_price' => $price, 'msg' => '<i class="fas fa-check-circle"></i> '.trans('coupon-applied-successfully')));

            }else{
                echo json_encode(array('st' => 0, 'msg' => '<i class="fas fa-times-circle"></i> '.trans('invalid-code')));
            }

        }
        
    }


    public function sync($booking_id)
    {  
        $this->session->set_userdata('booking_id', $booking_id);
        redirect(base_url('googlecalendar/login'));
    }


    public function add_review()
    {   
        
        check_status();
        
        if($_POST)
        {   
            $id = $this->input->post('booking_id',true);
            $booking = $this->common_model->get_by_id($id, 'session_booking');

            $data=array(
                'user_id' =>$booking->user_id,
                'session_id' =>$booking->session_id,
                'mentee_id' => $booking->mentee_id,
                'booking_id' => $id,
                'feedback' =>$this->input->post('feedback',true),
                'rating' => $this->input->post('rating',true),
                'created_at' =>my_date_now()
            );
            $data = $this->security->xss_clean($data);
            $id = $this->admin_model->insert($data, 'reviews');
            $this->session->set_flashdata('msg', trans('inserted-successfully'));

            $rating = $this->admin_model->get_by_id($id, 'reviews');
            $session_name = $this->admin_model->get_by_id($booking->session_id, 'sessions')->name;
            $mentee_name = $this->admin_model->get_by_id($booking->mentee_id, 'users')->name;
            // insert notification

            $notify = array(
                'user_id' => $booking->user_id,
                'action_id' =>$booking->mentee_id,
                'content_id' => 0,
                'text' => $mentee_name."gives ".$rating->rating ." star rating on your session : " .'"'.$session_name.'"',
                'noti_type' => 5,
                'noti_time' => my_date_now()
            );
            $notify = $this->security->xss_clean($notify);
            $this->common_model->insert($notify, 'notifications'); 
            
            redirect(base_url('admin/sessions/booking'));

        }

    }

/*
        Name : Zoom Meeting
        Purpose : Zoom join_url issue
        Original Author : Dharmendra Arya
        Created At : 22nd Feb 2025
    */
    public function add_meeting($id){
        // Update meeting_type to zoom when creating a Zoom meeting
        $this->db->where('id', $id);
        $this->db->update('session_booking', ['meeting_type' => 'zoom']);
        
        // Proceed with existing Zoom meeting creation
        $this->_add_meeting($id);
    }

    private function _add_meeting($id){

        if (settings()->zoom_api_user == 2) {
            $zoom_account_id = settings()->zoom_account_id; 
            $zoom_client_id = settings()->zoom_client_id; 
            $zoom_client_secret = settings()->zoom_client_secret; 
        } else {
            $zoom_account_id = user()->zoom_account_id; 
            $zoom_client_id = user()->zoom_client_id; 
            $zoom_client_secret = user()->zoom_client_secret; 
        }
        
        $appointment = $this->db->get_where('session_booking',['id'=>$id])->row();
        $mentee = $this->db->get_where('users',['id'=>$appointment->mentee_id])->row();
        $mentor = $this->db->get_where('users',['id'=>$appointment->user_id])->row();
        $session = $this->db->get_where('sessions',['id'=>$appointment->session_id])->row();

        // 22 feb 2025
        $meeting_id = "";
        $newMeeting = true;
        if ($session->enable_group_booking) { // check for group meeting
            $appointmentExistQuery = $this->db->get_where('session_booking', ['date'=>$appointment->date, 'time'=> $appointment->time]);

            if ($appointmentExistQuery->num_rows() > 1) { // if group meeting exist for more than 1 user
                $appointmentExist = $appointmentExistQuery->result();
                if ($appointmentExistQuery->num_rows() < $session->group_booking_slot) {
                    

                    foreach ($appointmentExist as $rows) {
                        if (!is_null($rows->host_url) || $rows->host_url != "") { //check if meeting host url is not null or empty
                            $newMeeting = false; // prevent from creating new zoom meeting
                            $join_url = $rows->join_url;
                            $host_url = $rows->host_url;
                            $password = $rows->zoom_password;

                            $urlArr = explode("/", $rows->host_url);
                            $meetingArr = explode("?", $urlArr[4]);
                            $meeting_id = $meetingArr[0];

                            break;
                        }
                    }
                    if (!$newMeeting) {
                        // die ("no new meeting needed: ".$join_url);
                    }
                    // die ("meeting id exists: ". $meeting_id);
                }
            }
        }
        // die ("meeting id not exists: ". $meeting_id);

        if ($newMeeting) { // 22 feb 2025 : create meeting only if above condition is failed "check for group meeting"

            $time = explode('-', $appointment->time);
            $date = date('Y-m-d');

            if(count($time) && $appointment->date != null ){
                $time1 = $time[0];
                $time2 = $time[1];
                $date = $appointment->date;
            }

            $start_time = $date.'T'.$time1.':00';

            $agenda = 'Zoom Meeting Session with - '.$mentor->name;
            $duration = $appointment->duration;
            $password = mt_rand(1111,9999);;

            $fields = array(
                'topic'=>$session->name.' - '.$appointment->booking_number.' - '.$mentor->name,
                'agenda'=>$agenda,
                'default_password'=>false,
                'duration'=>$duration, //minutes
                'password'=> $password,
                'start_time'=>$start_time,
                'timezone' => 'GMT+5:30',
                'waiting_room'=>true,
                //'type' => 2, Scheduled meeting
                'settings' => array(
                    'host_video' => true,
                    'participant_video' => true,
                    'join_before_host' => true,
                    'alternative_hosts' => '',
                    'auto_recording' => 'cloud'
                )
            );

            $result = $this->zoom->get_meeting($zoom_account_id, $zoom_client_id, $zoom_client_secret, $fields);
            $result = json_decode($result);
            $meeting_id = $result->id; // 22 feb 2025
            $host_url = $result->start_url;
            $join_url = $result->join_url;
        } // 22 feb 2025

        $mentees['attendees'] = array(
            0 => array('name'=> $mentee->name)
        );

        $invitation = $this->zoom->send_invitation($zoom_account_id, $zoom_client_id, $zoom_client_secret, $result->id, $mentees);
        // $join_url = null;

        // if(isset($invitation->attendees)){
        //     $join_url = $invitation->attendees[0]->join_url;
        // }

        $this->db->where('id',$id);
        $this->db->update('session_booking',['join_url'=>$join_url,'host_url'=>$host_url,'zoom_password'=>$password]);

        $this->session->set_flashdata('msg','Meeting added successfully'); 
        redirect(base_url('admin/sessions/booking'));
    }



    public function zoom($id){
       
        $edit_data = array(
            'is_start' => 1
        );
        if ($id != 0) {
            $this->admin_model->edit_option($edit_data, $id, 'session_booking');
        }
        redirect($_SERVER['HTTP_REFERER']);
        
    }


    public function meet($id){
        // Update meeting_type to meet when creating a Google Meet
        $this->db->where('id', $id);
        $this->db->update('session_booking', ['meeting_type' => 'meet']);
        
        // Continue with existing meet functionality
        if(!$this->session->userdata('logged_in')){
            redirect(base_url('auth'));
        }
        
        $booking = $this->admin_model->get_by_id($id,'session_booking');
        
        if (!empty($booking)) {
            $this->db->where('id', $id);
            $this->db->update('session_booking', ['is_start' => 1]);
            $this->session->set_flashdata('msg', trans('meeting-started-successfully')); 
        }
        redirect($_SERVER['HTTP_REFERER']);
    }



    public function cancel_meeting($id)
    {
        if(!$this->session->userdata('logged_in')){
            redirect(base_url('auth'));
        }
        
        $booking = $this->admin_model->get_by_id($id,'session_booking');
        
        if (!empty($booking)) {
            $this->db->where('id', $id);
            $this->db->update('session_booking', ['is_start' => 0, 'host_url' => '']);
            $this->session->set_flashdata('msg', trans('meeting-canceled-successfully')); 
        }
        redirect($_SERVER['HTTP_REFERER']);
    }



    public function mentee_details($id)
    {
        $data = array();
        $data['page'] = 'Sessions';   
        $data['page_title'] = 'Details';   
        $data['mentee'] = $this->admin_model->get_by_id($id, 'users');
        $data['sessions'] = $this->admin_model->get_mentee_sessions($data['mentee']->id);
        //echo '<pre>'; print_r($data['sessions']); exit();
        $data['main_content'] = $this->load->view('admin/user/mentee_details',$data,TRUE);
        $this->load->view('admin/index',$data);
    }

    public function booking_calendars()
    {
        $data = array();
        $data['page_title'] = 'Calendars';
        $data['bookings']=$this->admin_model->get_all_booking_calendars(user()->id);
        $data['main_content'] = $this->load->view('admin/user/calendars',$data,TRUE);
        $this->load->view('admin/index',$data);
    }

   public function self_assessment(){
        if($_POST)
        {   if($this->input->post('qns3',true) ==""){
                $qns3='';
            }else{
                $qns3=implode(",",$this->input->post('qns3',true));
            }
            if($this->input->post('qns4',true) ==""){
                $qns4='';
            }else{
                $qns4=implode(",",$this->input->post('qns4',true));
            }

            if($this->input->post('qns5',true) ==""){
                $qns5='';
            }else{
                $qns5=implode(",",$this->input->post('qns5',true));
            }
            $qns51ans=$this->input->post('qns51ans',true);
            $qns52ans=$this->input->post('qns52ans',true);
            $qns53ans=$this->input->post('qns53ans',true);
            $qns54ans=$this->input->post('qns54ans',true);
            $qns55ans=$this->input->post('qns55ans',true);
            $data = array(
                'qns1' => $this->input->post('qns1',true),
                'qns2' =>$this->input->post('qns2',true),
                'qns3' =>$qns3,
                'qns4' =>$qns4,
                'qns5' =>$qns5,
                'qns5ans' => implode("|-|",array($qns51ans,$qns52ans,$qns53ans,$qns54ans,$qns55ans)),
                'qns6ans' =>$this->input->post('qns6ans',true),
                'qns3ans' =>$this->input->post('qns35ans',true),
                'qns4ans' =>$this->input->post('qns46ans',true),
                'date' => my_date_now()
            );
            $data = $this->security->xss_clean($data);
            $id=$this->input->post('id',true);
            $bsedata=array('assessmentans'=>serialize($data),'assessment'=>1);
            $this->admin_model->edit_option($bsedata, $id, 'session_booking');
            echo json_encode(array('st' => 1,'msg' => 'Assessment added successfully'));
        }else{
            echo json_encode(array('st' => 2,'msg' => 'Please try again '));
        }
    }

    /**
     * Export bookings to CSV or Excel format
     * 
     * @param string $format Format (csv or excel)
     * @return void
     */
    public function export_bookings($format = 'csv')
    {
        check_status();
        error_reporting(E_ALL);
        ini_set('display_errors', 4);
        
        $search = $this->input->get('search');
        if (empty($search)) {
            $search = 'upcoming';
        }
        
        $session_id = $this->input->get('session');
        $mentee_id = $this->input->get('mentee');
        $mentor_id = $this->input->get('mentor');
        $status = $this->input->get('status');
        
        $type = user()->role;
        $user_id = user()->id;
        
        $bookings = $this->admin_model->get_all_bookings($type, $user_id, $total=0, 0, 0, $search);
        
        if (!empty($session_id) && $session_id != 'all' || 
            !empty($mentee_id) && $mentee_id != 'all' || 
            !empty($mentor_id) && $mentor_id != 'all' || 
            !empty($status) && $status != 'all') {
            
            $filtered_bookings = array();
            
            foreach ($bookings as $booking) {
                $include = true;
                
                if (!empty($session_id) && $session_id != 'all' && $booking->session_id != $session_id) {
                    $include = false;
                }
                
                if (!empty($mentee_id) && $mentee_id != 'all' && $booking->mentee_id != $mentee_id) {
                    $include = false;
                }
                
                if (!empty($mentor_id) && $mentor_id != 'all' && $booking->user_id != $mentor_id) {
                    $include = false;
                }
                
                if (!empty($status) && $status != 'all' && $booking->status != $status) {
                    $include = false;
                }
                
                if ($include) {
                    $filtered_bookings[] = $booking;
                }
            }
            
            $bookings = $filtered_bookings;
        }
        
        $filename = 'bookings_export_' . $search . '_' . date('Y-m-d');
        $header = [
            "Booking ID", 
            "Mentee Name", 
            "Mentee Email", 
            "Mentor Name", 
            "Mentor Email",
            "Session",
            "Price",
            "Duration",
            "Group Booking",
            "Date",
            "Time",
            "Status",
            "Payment Status"
        ];
        
        $rows = $this->get_booking_export_rows($bookings);
        
        // CSV export
        if ($format == 'csv') {
            $this->load->helper('file');
            $this->load->helper('download');
            // Add UTF-8 BOM to ensure proper encoding
            $csv_content = "\xEF\xBB\xBF"; 
            $csv_content .= implode(',', $header) . "\n";
            
            foreach ($rows as $row) {
                $escaped = array_map(function($v) { 
                    return '"' . str_replace('"', '""', $v) . '"'; 
                }, $row);
                $csv_content .= implode(',', $escaped) . "\n";
            }
            
            force_download("$filename.csv", $csv_content);
        }
        // Excel export
        elseif ($format == 'excel') {
            if (!class_exists('PhpOffice\\PhpSpreadsheet\\Spreadsheet')) {
                require_once FCPATH . 'vendor/autoload.php';
            }
            
            if (ob_get_length()) ob_end_clean();
            
            $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();
            
            // Headers
            $col = 'A';
            foreach ($header as $h) {
                $sheet->setCellValue($col.'1', $h);
                $col++;
            }
            
            // Style header
            $sheet->getStyle('A1:M1')->applyFromArray(['font' => ['bold' => true]]);
            
            // Data rows
            $rownum = 2;
            foreach ($rows as $row) {
                $col = 'A';
                foreach ($row as $cell) {
                    $sheet->setCellValueExplicit(
                        $col . $rownum, 
                        $cell, 
                        \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING
                    );
                    $col++;
                }
                $rownum++;
            }
            
            // Auto size columns
            foreach(range('A','M') as $col) {
                $sheet->getColumnDimension($col)->setAutoSize(true);
            }
            
            $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="'.$filename.'.xlsx"');
            header('Cache-Control: max-age=0');
            $writer->save('php://output');
            exit;
        }
    }
    
    /**
     * Format booking data for export
     * 
     * @param array $bookings Booking records
     * @return array Formatted rows for export
     */
    protected function get_booking_export_rows($bookings) 
    {
        $rows = array();
        
        foreach ($bookings as $booking) {
            // Get mentee details
            $mentee = $this->admin_model->get_by_id($booking->mentee_id, 'users');
            $mentee_name = $mentee ? $mentee->name : 'N/A';
            $mentee_email = $mentee ? $mentee->email : 'N/A';
            
            // Get mentor details
            $mentor = $this->admin_model->get_by_id($booking->user_id, 'users');
            $mentor_name = $mentor ? $mentor->name : 'N/A';
            $mentor_email = $mentor ? $mentor->email : 'N/A';
            
            // Get session details
            $session = $this->admin_model->get_by_id($booking->session_id, 'sessions');
            $session_name = $session ? $session->name : 'N/A';
            
            if ($booking->price == 0 || $booking->price == 'Free') {
                $price = 'Free';
            } else {
                $coupon = check_coupon_mentee($booking->session_id, $booking->mentee_id);
                if (empty($coupon)) {
                    $price = settings()->currency_code . ' ' . number_format($booking->price, settings()->num_format);
                } else {
                    $pbookings = get_by_datakey($booking->id, 'booking_id', 'coupon_apply');
                    if (!empty($pbookings)) {
                        $discount = $pbookings->discount;
                        $discount_amount = ($booking->price * $discount) / 100;
                        $price = settings()->currency_code . ' ' . number_format($booking->price - $discount_amount, settings()->num_format) . ' (Coupon applied)';
                    } else {
                        $price = settings()->currency_code . ' ' . number_format($booking->price, settings()->num_format);
                    }
                }
            }
            
            // Check if group booking is enabled
            $enable_group_booking = $session ? $session->enable_group_booking : 0;
            $group_booking = $enable_group_booking == 1 ? 'Yes' : 'No';
            
            // Format status
            $status_labels = ['Pending', 'Approved', 'Rejected', 'Completed', 'Cancelled'];
            $status = isset($status_labels[$booking->status]) ? $status_labels[$booking->status] : 'Unknown';
            
            // Format payment status
            $check_payment = check_booking_payment($booking->id);
            if ($booking->price == 0 || $booking->price == 'Free') {
                $payment_status = 'Free';
            } else {
                $payment_status = $check_payment == 1 ? 'Paid' : 'Pending';
            }
            
            $rows[] = [
                '#' . $booking->booking_number,
                $mentee_name,
                $mentee_email,
                $mentor_name,
                $mentor_email,
                $session_name,
                $price,
                $booking->duration . ' minutes',
                $group_booking,
                my_date_show($booking->date),
                $booking->time,
                $status,
                $payment_status
            ];
        }
        
        return $rows;
    }

}
    

