<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manual extends Home_Controller {

    public function __construct()
    {
        parent::__construct();
        //check auth
        if (!is_admin() && !is_user() && !is_mentee()) {
            redirect(base_url());
        }
    }

    public function index()
    {
        $data = array();
        $data['page_title'] = 'Manual';  
        $data['page'] = FALSE;
        if (is_admin()) {
            $uid = 0; $type='admin';
        } else {
            $uid = $this->business->uid;
            $type='user';
        }
        $data['pages'] = $this->admin_model->get_pages($uid, $type, 'all',2);
        $data['main_content'] = $this->load->view('admin/manual',$data,TRUE);
        $this->load->view('admin/index',$data);
    }

    public function add()
    {	
        check_status();
        if($_POST)
        {   
            $id = $this->input->post('id', true);
            //validate inputs
            $this->form_validation->set_rules('title', 'Title', 'required');
            
            if ($this->form_validation->run() === false) {
                $this->session->set_flashdata('error', validation_errors());
                redirect(base_url('admin/manual'));
            } else {
                if (is_admin()) {
                    $uid = 0; $type='admin';
                } else {
                    $uid = $this->business->uid;
                    $type='user';
                }  
                $data=array(
                    'lang_id' => 1,
                    'business_id' => 0,
                    'title' => $this->input->post('title', true),
                    'slug' => str_slug(trim($this->input->post('slug', true))),
                    'type' => $type,
                    'details' => $_POST['details'],
                    'status' => 1,
                    'pagetype' => 2,
                    'created_at' => my_date_now()
                );
               // $data = $this->security->xss_clean($data);
                //if id available info will be edited
                if ($id != '') {
                    //$this->admin_model->edit_option($data, $id, 'pages');
                    $this->db->where('id',$id);
                    $this->db->update('pages',$data);
                    $this->session->set_flashdata('msg', trans('updated-successfully')); 
                } else {
                    $id = $this->admin_model->insert($data, 'pages');
                    $this->session->set_flashdata('msg', trans('inserted-successfully')); 
                }
            }
            redirect(base_url('admin/manual'));

        }      
        
    }

    public function edit($id)
    {  
        $data = array();
        $data['page_title'] = 'Edit';   
        $data['page'] = $this->admin_model->select_option($id, 'pages');
        $data['main_content'] = $this->load->view('admin/manual',$data,TRUE);
        $this->load->view('admin/index',$data);
    }

    
    public function active($id) 
    {
        $data = array(
            'status' => 1
        );
        $data = $this->security->xss_clean($data);
        $this->admin_model->update($data, $id,'pages');
        $this->session->set_flashdata('msg', trans('activate-successfully')); 
        redirect(base_url('admin/manual'));
    }

    public function update_status($status, $id) 
    {
        $data = array(
            'status' => $status
        );
        $data = $this->security->xss_clean($data);
        $this->admin_model->update($data, $id,'pages');
        $this->session->set_flashdata('msg', trans('update-status-successfully')); 
        redirect(base_url('admin/manual'));
    }

    public function delete($id)
    {
        $this->admin_model->delete($id,'manual'); 
        echo json_encode(array('st' => 1));
    }
    public function usermanual()
    {
        $data = array();
        $data['page'] = 'Users';   
        $data['page_title'] = 'Manual';   
        if(is_user()){
            $data['dec']=$this->admin_model->get_pages_by_slug('mentor-manual');
        }else{
            $data['dec']=$this->admin_model->get_pages_by_slug('mentee-manual');
        }
        $data['main_content'] = $this->load->view('admin/user/manual',$data,TRUE);
        $this->load->view('admin/index',$data);
    }
}
	

